package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The buffer cache used to cache static content
 */
@ResourceType("buffer-cache")
public class BufferCache<T extends BufferCache> {

	private String key;
	private Integer bufferSize;
	private Integer buffersPerRegion;
	private Integer maxRegions;

	public BufferCache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The size of an individual buffer
	 */
	@ModelNodeBinding(detypedName = "buffer-size")
	public Integer bufferSize() {
		return this.bufferSize;
	}

	/**
	 * The size of an individual buffer
	 */
	@SuppressWarnings("unchecked")
	public T bufferSize(Integer value) {
		this.bufferSize = value;
		return (T) this;
	}

	/**
	 * The numbers of buffers in a region
	 */
	@ModelNodeBinding(detypedName = "buffers-per-region")
	public Integer buffersPerRegion() {
		return this.buffersPerRegion;
	}

	/**
	 * The numbers of buffers in a region
	 */
	@SuppressWarnings("unchecked")
	public T buffersPerRegion(Integer value) {
		this.buffersPerRegion = value;
		return (T) this;
	}

	/**
	 * The maximum number of regions
	 */
	@ModelNodeBinding(detypedName = "max-regions")
	public Integer maxRegions() {
		return this.maxRegions;
	}

	/**
	 * The maximum number of regions
	 */
	@SuppressWarnings("unchecked")
	public T maxRegions(Integer value) {
		this.maxRegions = value;
		return (T) this;
	}
}