package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.Host;
import org.wildfly.swarm.config.undertow.server.HostConfigurator;
import org.wildfly.swarm.config.undertow.server.HTTPListener;
import org.wildfly.swarm.config.undertow.server.HTTPListenerConfigurator;
import org.wildfly.swarm.config.undertow.server.AJPListener;
import org.wildfly.swarm.config.undertow.server.AJPListenerConfigurator;
import org.wildfly.swarm.config.undertow.server.HttpsListener;
import org.wildfly.swarm.config.undertow.server.HttpsListenerConfigurator;
/**
 * A server
 */
@ResourceType("server")
public class Server<T extends Server> {

	private String key;
	private String defaultHost;
	private String servletContainer;
	private ServerResources subresources = new ServerResources();

	public Server(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The servers default virtual host
	 */
	@ModelNodeBinding(detypedName = "default-host")
	public String defaultHost() {
		return this.defaultHost;
	}

	/**
	 * The servers default virtual host
	 */
	@SuppressWarnings("unchecked")
	public T defaultHost(String value) {
		this.defaultHost = value;
		return (T) this;
	}

	/**
	 * The servers default servlet container
	 */
	@ModelNodeBinding(detypedName = "servlet-container")
	public String servletContainer() {
		return this.servletContainer;
	}

	/**
	 * The servers default servlet container
	 */
	@SuppressWarnings("unchecked")
	public T servletContainer(String value) {
		this.servletContainer = value;
		return (T) this;
	}

	public ServerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.Host objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.Host objects.
	 */
	@SuppressWarnings("unchecked")
	public T hosts(List<org.wildfly.swarm.config.undertow.server.Host> value) {
		this.subresources.hosts = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.Host object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.Host to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T host(Host value) {
		this.subresources.hosts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.Host object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.Host resource
	 * @param config The org.wildfly.swarm.config.undertow.server.HostConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T host(String childKey, HostConfigurator config) {
		org.wildfly.swarm.config.undertow.server.Host child = new org.wildfly.swarm.config.undertow.server.Host(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		host(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.Host object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.Host resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T host(String childKey) {
		host(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.HTTPListener objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.HTTPListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpListeners(
			List<org.wildfly.swarm.config.undertow.server.HTTPListener> value) {
		this.subresources.httpListeners = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.HTTPListener object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.HTTPListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(HTTPListener value) {
		this.subresources.httpListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HTTPListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HTTPListener resource
	 * @param config The org.wildfly.swarm.config.undertow.server.HTTPListenerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(String childKey, HTTPListenerConfigurator config) {
		org.wildfly.swarm.config.undertow.server.HTTPListener child = new org.wildfly.swarm.config.undertow.server.HTTPListener(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		httpListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HTTPListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HTTPListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpListener(String childKey) {
		httpListener(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.AJPListener objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.AJPListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T ajpListeners(
			List<org.wildfly.swarm.config.undertow.server.AJPListener> value) {
		this.subresources.ajpListeners = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.AJPListener object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.AJPListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(AJPListener value) {
		this.subresources.ajpListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.AJPListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.AJPListener resource
	 * @param config The org.wildfly.swarm.config.undertow.server.AJPListenerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(String childKey, AJPListenerConfigurator config) {
		org.wildfly.swarm.config.undertow.server.AJPListener child = new org.wildfly.swarm.config.undertow.server.AJPListener(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		ajpListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.AJPListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.AJPListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T ajpListener(String childKey) {
		ajpListener(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.HttpsListener objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.HttpsListener objects.
	 */
	@SuppressWarnings("unchecked")
	public T httpsListeners(
			List<org.wildfly.swarm.config.undertow.server.HttpsListener> value) {
		this.subresources.httpsListeners = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.HttpsListener object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.HttpsListener to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(HttpsListener value) {
		this.subresources.httpsListeners.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HttpsListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HttpsListener resource
	 * @param config The org.wildfly.swarm.config.undertow.server.HttpsListenerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(String childKey, HttpsListenerConfigurator config) {
		org.wildfly.swarm.config.undertow.server.HttpsListener child = new org.wildfly.swarm.config.undertow.server.HttpsListener(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		httpsListener(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.HttpsListener object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.HttpsListener resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T httpsListener(String childKey) {
		httpsListener(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for Server
	 */
	public class ServerResources {
		/**
		 * An Undertow host
		 */
		private List<org.wildfly.swarm.config.undertow.server.Host> hosts = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<org.wildfly.swarm.config.undertow.server.HTTPListener> httpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<org.wildfly.swarm.config.undertow.server.AJPListener> ajpListeners = new java.util.ArrayList<>();
		/**
		 * http listener
		 */
		private List<org.wildfly.swarm.config.undertow.server.HttpsListener> httpsListeners = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.Host resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Host> hosts() {
			return this.hosts;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.HTTPListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HTTPListener> httpListeners() {
			return this.httpListeners;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.AJPListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<AJPListener> ajpListeners() {
			return this.ajpListeners;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.HttpsListener resources
		 * @return the list of resources
		 */
		@Subresource
		public List<HttpsListener> httpsListeners() {
			return this.httpsListeners;
		}
	}
}