package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMapping;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMappingConfigurator;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileConfigurator;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSetting;
/**
 * A servlet container
 */
@ResourceType("servlet-container")
public class ServletContainer<T extends ServletContainer> {

	private String key;
	private Boolean allowNonStandardWrappers;
	private String defaultBufferCache;
	private String defaultEncoding;
	private Integer defaultSessionTimeout;
	private Boolean directoryListing;
	private Boolean disableCachingForSecuredPages;
	private Boolean eagerFilterInitialization;
	private Boolean ignoreFlush;
	private Integer maxSessions;
	private Boolean proactiveAuthentication;
	private Integer sessionIdLength;
	private String stackTraceOnError;
	private Boolean useListenerEncoding;
	private ServletContainerResources subresources = new ServletContainerResources();
	private PersistentSessionsSetting persistentSessionsSetting;
	private JSPSetting jspSetting;
	private WebsocketsSetting websocketsSetting;
	private SessionCookieSetting sessionCookieSetting;

	public ServletContainer(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If true then request and response wrappers that do not extend the standard wrapper classes can be used
	 */
	@ModelNodeBinding(detypedName = "allow-non-standard-wrappers")
	public Boolean allowNonStandardWrappers() {
		return this.allowNonStandardWrappers;
	}

	/**
	 * If true then request and response wrappers that do not extend the standard wrapper classes can be used
	 */
	@SuppressWarnings("unchecked")
	public T allowNonStandardWrappers(Boolean value) {
		this.allowNonStandardWrappers = value;
		return (T) this;
	}

	/**
	 * The buffer cache to use for caching static resources
	 */
	@ModelNodeBinding(detypedName = "default-buffer-cache")
	public String defaultBufferCache() {
		return this.defaultBufferCache;
	}

	/**
	 * The buffer cache to use for caching static resources
	 */
	@SuppressWarnings("unchecked")
	public T defaultBufferCache(String value) {
		this.defaultBufferCache = value;
		return (T) this;
	}

	/**
	 * Default encoding to use for all deployed applications
	 */
	@ModelNodeBinding(detypedName = "default-encoding")
	public String defaultEncoding() {
		return this.defaultEncoding;
	}

	/**
	 * Default encoding to use for all deployed applications
	 */
	@SuppressWarnings("unchecked")
	public T defaultEncoding(String value) {
		this.defaultEncoding = value;
		return (T) this;
	}

	/**
	 * The default session timeout (in minutes) for all applications deployed in the container.
	 */
	@ModelNodeBinding(detypedName = "default-session-timeout")
	public Integer defaultSessionTimeout() {
		return this.defaultSessionTimeout;
	}

	/**
	 * The default session timeout (in minutes) for all applications deployed in the container.
	 */
	@SuppressWarnings("unchecked")
	public T defaultSessionTimeout(Integer value) {
		this.defaultSessionTimeout = value;
		return (T) this;
	}

	/**
	 * If directory listing should be enabled for default servlets.
	 */
	@ModelNodeBinding(detypedName = "directory-listing")
	public Boolean directoryListing() {
		return this.directoryListing;
	}

	/**
	 * If directory listing should be enabled for default servlets.
	 */
	@SuppressWarnings("unchecked")
	public T directoryListing(Boolean value) {
		this.directoryListing = value;
		return (T) this;
	}

	/**
	 * If Undertow should set headers to disable caching for secured paged. Disabling this can cause security problems, as sensitive pages may be cached by an intermediary.
	 */
	@ModelNodeBinding(detypedName = "disable-caching-for-secured-pages")
	public Boolean disableCachingForSecuredPages() {
		return this.disableCachingForSecuredPages;
	}

	/**
	 * If Undertow should set headers to disable caching for secured paged. Disabling this can cause security problems, as sensitive pages may be cached by an intermediary.
	 */
	@SuppressWarnings("unchecked")
	public T disableCachingForSecuredPages(Boolean value) {
		this.disableCachingForSecuredPages = value;
		return (T) this;
	}

	/**
	 * If true undertow calls filter init() on deployment start rather than when first requested.
	 */
	@ModelNodeBinding(detypedName = "eager-filter-initialization")
	public Boolean eagerFilterInitialization() {
		return this.eagerFilterInitialization;
	}

	/**
	 * If true undertow calls filter init() on deployment start rather than when first requested.
	 */
	@SuppressWarnings("unchecked")
	public T eagerFilterInitialization(Boolean value) {
		this.eagerFilterInitialization = value;
		return (T) this;
	}

	/**
	 * Ignore flushes on the servlet output stream. In most cases these just hurt performance for no good reason.
	 */
	@ModelNodeBinding(detypedName = "ignore-flush")
	public Boolean ignoreFlush() {
		return this.ignoreFlush;
	}

	/**
	 * Ignore flushes on the servlet output stream. In most cases these just hurt performance for no good reason.
	 */
	@SuppressWarnings("unchecked")
	public T ignoreFlush(Boolean value) {
		this.ignoreFlush = value;
		return (T) this;
	}

	/**
	 * The maximum number of sessions that can be active at one time
	 */
	@ModelNodeBinding(detypedName = "max-sessions")
	public Integer maxSessions() {
		return this.maxSessions;
	}

	/**
	 * The maximum number of sessions that can be active at one time
	 */
	@SuppressWarnings("unchecked")
	public T maxSessions(Integer value) {
		this.maxSessions = value;
		return (T) this;
	}

	/**
	 * If proactive authentication should be used. If this is true a user will always be authenticated if credentials are present.
	 */
	@ModelNodeBinding(detypedName = "proactive-authentication")
	public Boolean proactiveAuthentication() {
		return this.proactiveAuthentication;
	}

	/**
	 * If proactive authentication should be used. If this is true a user will always be authenticated if credentials are present.
	 */
	@SuppressWarnings("unchecked")
	public T proactiveAuthentication(Boolean value) {
		this.proactiveAuthentication = value;
		return (T) this;
	}

	/**
	 * The length of the generated session ID. Longer session ID's are more secure.
	 */
	@ModelNodeBinding(detypedName = "session-id-length")
	public Integer sessionIdLength() {
		return this.sessionIdLength;
	}

	/**
	 * The length of the generated session ID. Longer session ID's are more secure.
	 */
	@SuppressWarnings("unchecked")
	public T sessionIdLength(Integer value) {
		this.sessionIdLength = value;
		return (T) this;
	}

	/**
	 * If an error page with the stack trace should be generated on error. Values are all, none and local-only
	 */
	@ModelNodeBinding(detypedName = "stack-trace-on-error")
	public String stackTraceOnError() {
		return this.stackTraceOnError;
	}

	/**
	 * If an error page with the stack trace should be generated on error. Values are all, none and local-only
	 */
	@SuppressWarnings("unchecked")
	public T stackTraceOnError(String value) {
		this.stackTraceOnError = value;
		return (T) this;
	}

	/**
	 * Use encoding defined on listener
	 */
	@ModelNodeBinding(detypedName = "use-listener-encoding")
	public Boolean useListenerEncoding() {
		return this.useListenerEncoding;
	}

	/**
	 * Use encoding defined on listener
	 */
	@SuppressWarnings("unchecked")
	public T useListenerEncoding(Boolean value) {
		this.useListenerEncoding = value;
		return (T) this;
	}

	public ServletContainerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.servlet_container.MimeMapping objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.servlet_container.MimeMapping objects.
	 */
	@SuppressWarnings("unchecked")
	public T mimeMappings(
			List<org.wildfly.swarm.config.undertow.servlet_container.MimeMapping> value) {
		this.subresources.mimeMappings = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.servlet_container.MimeMapping object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.servlet_container.MimeMapping to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(MimeMapping value) {
		this.subresources.mimeMappings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.servlet_container.MimeMapping object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.servlet_container.MimeMapping resource
	 * @param config The org.wildfly.swarm.config.undertow.servlet_container.MimeMappingConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(String childKey, MimeMappingConfigurator config) {
		org.wildfly.swarm.config.undertow.servlet_container.MimeMapping child = new org.wildfly.swarm.config.undertow.servlet_container.MimeMapping(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		mimeMapping(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.servlet_container.MimeMapping object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.servlet_container.MimeMapping resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(String childKey) {
		mimeMapping(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile objects.
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFiles(
			List<org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile> value) {
		this.subresources.welcomeFiles = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(WelcomeFile value) {
		this.subresources.welcomeFiles.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile resource
	 * @param config The org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(String childKey, WelcomeFileConfigurator config) {
		org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile child = new org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		welcomeFile(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(String childKey) {
		welcomeFile(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for ServletContainer
	 */
	public class ServletContainerResources {
		/**
		 * The servlet container mime mapping config
		 */
		private List<org.wildfly.swarm.config.undertow.servlet_container.MimeMapping> mimeMappings = new java.util.ArrayList<>();
		/**
		 * The welcome file
		 */
		private List<org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile> welcomeFiles = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.servlet_container.MimeMapping resources
		 * @return the list of resources
		 */
		@Subresource
		public List<MimeMapping> mimeMappings() {
			return this.mimeMappings;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile resources
		 * @return the list of resources
		 */
		@Subresource
		public List<WelcomeFile> welcomeFiles() {
			return this.welcomeFiles;
		}
	}

	/**
	 * Session persistence sessions
	 */
	@Subresource
	public PersistentSessionsSetting persistentSessionsSetting() {
		return this.persistentSessionsSetting;
	}

	/**
	 * Session persistence sessions
	 */
	@SuppressWarnings("unchecked")
	public T persistentSessionsSetting(PersistentSessionsSetting value) {
		this.persistentSessionsSetting = value;
		return (T) this;
	}

	/**
	 * JSP container configuration.
	 */
	@Subresource
	public JSPSetting jspSetting() {
		return this.jspSetting;
	}

	/**
	 * JSP container configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jspSetting(JSPSetting value) {
		this.jspSetting = value;
		return (T) this;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@Subresource
	public WebsocketsSetting websocketsSetting() {
		return this.websocketsSetting;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@SuppressWarnings("unchecked")
	public T websocketsSetting(WebsocketsSetting value) {
		this.websocketsSetting = value;
		return (T) this;
	}

	/**
	 * Session cookie configuration
	 */
	@Subresource
	public SessionCookieSetting sessionCookieSetting() {
		return this.sessionCookieSetting;
	}

	/**
	 * Session cookie configuration
	 */
	@SuppressWarnings("unchecked")
	public T sessionCookieSetting(SessionCookieSetting value) {
		this.sessionCookieSetting = value;
		return (T) this;
	}
}