package org.wildfly.swarm.config.undertow.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.host.FilterRef;
import org.wildfly.swarm.config.undertow.server.host.FilterRefConfigurator;
import org.wildfly.swarm.config.undertow.server.host.Location;
import org.wildfly.swarm.config.undertow.server.host.LocationConfigurator;
import org.wildfly.swarm.config.undertow.server.host.AccessLogSetting;
import org.wildfly.swarm.config.undertow.server.host.SingleSignOnSetting;
/**
 * An Undertow host
 */
@ResourceType("host")
public class Host<T extends Host> {

	private String key;
	private List<String> alias;
	private Integer defaultResponseCode;
	private String defaultWebModule;
	private Boolean disableConsoleRedirect;
	private HostResources subresources = new HostResources();
	private AccessLogSetting accessLogSetting;
	private SingleSignOnSetting singleSignOnSetting;

	public Host(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Aliases for the host
	 */
	@ModelNodeBinding(detypedName = "alias")
	public List<String> alias() {
		return this.alias;
	}

	/**
	 * Aliases for the host
	 */
	@SuppressWarnings("unchecked")
	public T alias(List<String> value) {
		this.alias = value;
		return (T) this;
	}

	/**
	 * Aliases for the host
	 */
	public T alias(String value) {
		if (this.alias == null) {
			this.alias = new java.util.ArrayList<>();
		}
		this.alias.add(value);
		return (T) this;
	}

	/**
	 * If set, this will be response code sent back in case requested context does not exist on server.
	 */
	@ModelNodeBinding(detypedName = "default-response-code")
	public Integer defaultResponseCode() {
		return this.defaultResponseCode;
	}

	/**
	 * If set, this will be response code sent back in case requested context does not exist on server.
	 */
	@SuppressWarnings("unchecked")
	public T defaultResponseCode(Integer value) {
		this.defaultResponseCode = value;
		return (T) this;
	}

	/**
	 * Default web module
	 */
	@ModelNodeBinding(detypedName = "default-web-module")
	public String defaultWebModule() {
		return this.defaultWebModule;
	}

	/**
	 * Default web module
	 */
	@SuppressWarnings("unchecked")
	public T defaultWebModule(String value) {
		this.defaultWebModule = value;
		return (T) this;
	}

	/**
	 * if set to true, /console redirect wont be enabled for this host, default is false
	 */
	@ModelNodeBinding(detypedName = "disable-console-redirect")
	public Boolean disableConsoleRedirect() {
		return this.disableConsoleRedirect;
	}

	/**
	 * if set to true, /console redirect wont be enabled for this host, default is false
	 */
	@SuppressWarnings("unchecked")
	public T disableConsoleRedirect(Boolean value) {
		this.disableConsoleRedirect = value;
		return (T) this;
	}

	public HostResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.host.FilterRef objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.host.FilterRef objects.
	 */
	@SuppressWarnings("unchecked")
	public T filterRefs(
			List<org.wildfly.swarm.config.undertow.server.host.FilterRef> value) {
		this.subresources.filterRefs = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.host.FilterRef object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.host.FilterRef to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(FilterRef value) {
		this.subresources.filterRefs.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.host.FilterRef object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.host.FilterRef resource
	 * @param config The org.wildfly.swarm.config.undertow.server.host.FilterRefConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(String childKey, FilterRefConfigurator config) {
		org.wildfly.swarm.config.undertow.server.host.FilterRef child = new org.wildfly.swarm.config.undertow.server.host.FilterRef(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		filterRef(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.host.FilterRef object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.host.FilterRef resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T filterRef(String childKey) {
		filterRef(childKey, null);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.server.host.Location objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.server.host.Location objects.
	 */
	@SuppressWarnings("unchecked")
	public T locations(
			List<org.wildfly.swarm.config.undertow.server.host.Location> value) {
		this.subresources.locations = value;
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.server.host.Location object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.server.host.Location to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T location(Location value) {
		this.subresources.locations.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.host.Location object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.host.Location resource
	 * @param config The org.wildfly.swarm.config.undertow.server.host.LocationConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T location(String childKey, LocationConfigurator config) {
		org.wildfly.swarm.config.undertow.server.host.Location child = new org.wildfly.swarm.config.undertow.server.host.Location(
				childKey);
		if (config != null) {
			config.configure(child);
		}
		location(child);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.server.host.Location object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.server.host.Location resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T location(String childKey) {
		location(childKey, null);
		return (T) this;
	}

	/**
	 * Child mutators for Host
	 */
	public class HostResources {
		/**
		 * Reference to filter
		 */
		private List<org.wildfly.swarm.config.undertow.server.host.FilterRef> filterRefs = new java.util.ArrayList<>();
		/**
		 * Holds configuration of location resource
		 */
		private List<org.wildfly.swarm.config.undertow.server.host.Location> locations = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.host.FilterRef resources
		 * @return the list of resources
		 */
		@Subresource
		public List<FilterRef> filterRefs() {
			return this.filterRefs;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.server.host.Location resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Location> locations() {
			return this.locations;
		}
	}

	/**
	 * The access log configuration for this virtual server.
	 */
	@Subresource
	public AccessLogSetting accessLogSetting() {
		return this.accessLogSetting;
	}

	/**
	 * The access log configuration for this virtual server.
	 */
	@SuppressWarnings("unchecked")
	public T accessLogSetting(AccessLogSetting value) {
		this.accessLogSetting = value;
		return (T) this;
	}

	/**
	 * The SSO configuration for this virtual server.
	 */
	@Subresource
	public SingleSignOnSetting singleSignOnSetting() {
		return this.singleSignOnSetting;
	}

	/**
	 * The SSO configuration for this virtual server.
	 */
	@SuppressWarnings("unchecked")
	public T singleSignOnSetting(SingleSignOnSetting value) {
		this.singleSignOnSetting = value;
		return (T) this;
	}
}