package org.wildfly.swarm.config.undertow.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * http listener
 */
@ResourceType("https-listener")
public class HttpsListener<T extends HttpsListener> {

	private String key;
	private Boolean allowEncodedSlash;
	private Boolean allowEqualsInCookieValue;
	private Boolean alwaysSetKeepAlive;
	private Boolean bufferPipelinedData;
	private String bufferPool;
	private Long bytesReceived;
	private Long bytesSent;
	private Boolean decodeUrl;
	private List<String> disallowedMethods;
	private Boolean enableHttp2;
	private Boolean enableSpdy;
	private Boolean enabled;
	private String enabledCipherSuites;
	private String enabledProtocols;
	private Long errorCount;
	private Integer maxBufferedRequestSize;
	private Integer maxConnections;
	private Integer maxCookies;
	private Integer maxHeaderSize;
	private Integer maxHeaders;
	private Integer maxParameters;
	private Long maxPostSize;
	private Long maxProcessingTime;
	private Integer noRequestTimeout;
	private Long processingTime;
	private Integer readTimeout;
	private Integer receiveBuffer;
	private Boolean recordRequestStartTime;
	private Long requestCount;
	private Integer requestParseTimeout;
	private Boolean resolvePeerAddress;
	private String securityRealm;
	private Integer sendBuffer;
	private String socketBinding;
	private Integer sslSessionCacheSize;
	private Integer sslSessionTimeout;
	private Integer tcpBacklog;
	private Boolean tcpKeepAlive;
	private String urlCharset;
	private String verifyClient;
	private String worker;
	private Integer writeTimeout;

	public HttpsListener(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If a request comes in with encoded / characters (i.e. %2F), will these be decoded.
	 */
	@ModelNodeBinding(detypedName = "allow-encoded-slash")
	public Boolean allowEncodedSlash() {
		return this.allowEncodedSlash;
	}

	/**
	 * If a request comes in with encoded / characters (i.e. %2F), will these be decoded.
	 */
	@SuppressWarnings("unchecked")
	public T allowEncodedSlash(Boolean value) {
		this.allowEncodedSlash = value;
		return (T) this;
	}

	/**
	 * If this is true then Undertow will allow non-escaped equals characters in unquoted cookie values. Unquoted cookie values may not contain equals characters. If present the value ends before the equals sign. The remainder of the cookie value will be dropped.
	 */
	@ModelNodeBinding(detypedName = "allow-equals-in-cookie-value")
	public Boolean allowEqualsInCookieValue() {
		return this.allowEqualsInCookieValue;
	}

	/**
	 * If this is true then Undertow will allow non-escaped equals characters in unquoted cookie values. Unquoted cookie values may not contain equals characters. If present the value ends before the equals sign. The remainder of the cookie value will be dropped.
	 */
	@SuppressWarnings("unchecked")
	public T allowEqualsInCookieValue(Boolean value) {
		this.allowEqualsInCookieValue = value;
		return (T) this;
	}

	/**
	 * If this is true then a Connection: keep-alive header will be added to responses, even when it is not strictly required by the specification.
	 */
	@ModelNodeBinding(detypedName = "always-set-keep-alive")
	public Boolean alwaysSetKeepAlive() {
		return this.alwaysSetKeepAlive;
	}

	/**
	 * If this is true then a Connection: keep-alive header will be added to responses, even when it is not strictly required by the specification.
	 */
	@SuppressWarnings("unchecked")
	public T alwaysSetKeepAlive(Boolean value) {
		this.alwaysSetKeepAlive = value;
		return (T) this;
	}

	/**
	 * If we should buffer pipelined requests.
	 */
	@ModelNodeBinding(detypedName = "buffer-pipelined-data")
	public Boolean bufferPipelinedData() {
		return this.bufferPipelinedData;
	}

	/**
	 * If we should buffer pipelined requests.
	 */
	@SuppressWarnings("unchecked")
	public T bufferPipelinedData(Boolean value) {
		this.bufferPipelinedData = value;
		return (T) this;
	}

	/**
	 * The AJP listeners buffer pool
	 */
	@ModelNodeBinding(detypedName = "buffer-pool")
	public String bufferPool() {
		return this.bufferPool;
	}

	/**
	 * The AJP listeners buffer pool
	 */
	@SuppressWarnings("unchecked")
	public T bufferPool(String value) {
		this.bufferPool = value;
		return (T) this;
	}

	/**
	 * The number of bytes that have been received by this listener
	 */
	@ModelNodeBinding(detypedName = "bytes-received")
	public Long bytesReceived() {
		return this.bytesReceived;
	}

	/**
	 * The number of bytes that have been received by this listener
	 */
	@SuppressWarnings("unchecked")
	public T bytesReceived(Long value) {
		this.bytesReceived = value;
		return (T) this;
	}

	/**
	 * The number of bytes that have been sent out on this listener
	 */
	@ModelNodeBinding(detypedName = "bytes-sent")
	public Long bytesSent() {
		return this.bytesSent;
	}

	/**
	 * The number of bytes that have been sent out on this listener
	 */
	@SuppressWarnings("unchecked")
	public T bytesSent(Long value) {
		this.bytesSent = value;
		return (T) this;
	}

	/**
	 * If this is true then the parser will decode the URL and query parameters using the selected character encoding (UTF-8 by default). If this is false they will not be decoded. This will allow a later handler to decode them into whatever charset is desired.
	 */
	@ModelNodeBinding(detypedName = "decode-url")
	public Boolean decodeUrl() {
		return this.decodeUrl;
	}

	/**
	 * If this is true then the parser will decode the URL and query parameters using the selected character encoding (UTF-8 by default). If this is false they will not be decoded. This will allow a later handler to decode them into whatever charset is desired.
	 */
	@SuppressWarnings("unchecked")
	public T decodeUrl(Boolean value) {
		this.decodeUrl = value;
		return (T) this;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@ModelNodeBinding(detypedName = "disallowed-methods")
	public List<String> disallowedMethods() {
		return this.disallowedMethods;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	@SuppressWarnings("unchecked")
	public T disallowedMethods(List<String> value) {
		this.disallowedMethods = value;
		return (T) this;
	}

	/**
	 * A comma separated list of HTTP methods that are not allowed
	 */
	public T disallowedMethod(String value) {
		if (this.disallowedMethods == null) {
			this.disallowedMethods = new java.util.ArrayList<>();
		}
		this.disallowedMethods.add(value);
		return (T) this;
	}

	/**
	 * Enables HTTP2 support for this listener
	 */
	@ModelNodeBinding(detypedName = "enable-http2")
	public Boolean enableHttp2() {
		return this.enableHttp2;
	}

	/**
	 * Enables HTTP2 support for this listener
	 */
	@SuppressWarnings("unchecked")
	public T enableHttp2(Boolean value) {
		this.enableHttp2 = value;
		return (T) this;
	}

	/**
	 * Enables SPDY support for this listener
	 */
	@ModelNodeBinding(detypedName = "enable-spdy")
	public Boolean enableSpdy() {
		return this.enableSpdy;
	}

	/**
	 * Enables SPDY support for this listener
	 */
	@SuppressWarnings("unchecked")
	public T enableSpdy(Boolean value) {
		this.enableSpdy = value;
		return (T) this;
	}

	/**
	 * If the listener is enabled
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If the listener is enabled
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		this.enabled = value;
		return (T) this;
	}

	/**
	 * Configures Enabled SSL cyphers
	 */
	@ModelNodeBinding(detypedName = "enabled-cipher-suites")
	public String enabledCipherSuites() {
		return this.enabledCipherSuites;
	}

	/**
	 * Configures Enabled SSL cyphers
	 */
	@SuppressWarnings("unchecked")
	public T enabledCipherSuites(String value) {
		this.enabledCipherSuites = value;
		return (T) this;
	}

	/**
	 * Configures SSL protocols
	 */
	@ModelNodeBinding(detypedName = "enabled-protocols")
	public String enabledProtocols() {
		return this.enabledProtocols;
	}

	/**
	 * Configures SSL protocols
	 */
	@SuppressWarnings("unchecked")
	public T enabledProtocols(String value) {
		this.enabledProtocols = value;
		return (T) this;
	}

	/**
	 * The number of 500 responses that have been sent by this listener
	 */
	@ModelNodeBinding(detypedName = "error-count")
	public Long errorCount() {
		return this.errorCount;
	}

	/**
	 * The number of 500 responses that have been sent by this listener
	 */
	@SuppressWarnings("unchecked")
	public T errorCount(Long value) {
		this.errorCount = value;
		return (T) this;
	}

	/**
	 * Maximum size of a buffered request, in bytesRequests are not usually buffered, the most common case is when performing SSL renegotiation for a POST request, and the post data must be fullybuffered in order to perform the renegotiation.
	 */
	@ModelNodeBinding(detypedName = "max-buffered-request-size")
	public Integer maxBufferedRequestSize() {
		return this.maxBufferedRequestSize;
	}

	/**
	 * Maximum size of a buffered request, in bytesRequests are not usually buffered, the most common case is when performing SSL renegotiation for a POST request, and the post data must be fullybuffered in order to perform the renegotiation.
	 */
	@SuppressWarnings("unchecked")
	public T maxBufferedRequestSize(Integer value) {
		this.maxBufferedRequestSize = value;
		return (T) this;
	}

	/**
	 * The maximum number of concurrent connections.
	 */
	@ModelNodeBinding(detypedName = "max-connections")
	public Integer maxConnections() {
		return this.maxConnections;
	}

	/**
	 * The maximum number of concurrent connections.
	 */
	@SuppressWarnings("unchecked")
	public T maxConnections(Integer value) {
		this.maxConnections = value;
		return (T) this;
	}

	/**
	 * The maximum number of cookies that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@ModelNodeBinding(detypedName = "max-cookies")
	public Integer maxCookies() {
		return this.maxCookies;
	}

	/**
	 * The maximum number of cookies that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@SuppressWarnings("unchecked")
	public T maxCookies(Integer value) {
		this.maxCookies = value;
		return (T) this;
	}

	/**
	 * The maximum size in bytes of a http request header.
	 */
	@ModelNodeBinding(detypedName = "max-header-size")
	public Integer maxHeaderSize() {
		return this.maxHeaderSize;
	}

	/**
	 * The maximum size in bytes of a http request header.
	 */
	@SuppressWarnings("unchecked")
	public T maxHeaderSize(Integer value) {
		this.maxHeaderSize = value;
		return (T) this;
	}

	/**
	 * The maximum number of headers that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@ModelNodeBinding(detypedName = "max-headers")
	public Integer maxHeaders() {
		return this.maxHeaders;
	}

	/**
	 * The maximum number of headers that will be parsed. This is used to protect against hash vulnerabilities.
	 */
	@SuppressWarnings("unchecked")
	public T maxHeaders(Integer value) {
		this.maxHeaders = value;
		return (T) this;
	}

	/**
	 * The maximum number of parameters that will be parsed. This is used to protect against hash vulnerabilities.This applies to both query parameters, and to POST data, but is not cumulative (i.e. you can potentially have max parameters * 2 total parameters).
	 */
	@ModelNodeBinding(detypedName = "max-parameters")
	public Integer maxParameters() {
		return this.maxParameters;
	}

	/**
	 * The maximum number of parameters that will be parsed. This is used to protect against hash vulnerabilities.This applies to both query parameters, and to POST data, but is not cumulative (i.e. you can potentially have max parameters * 2 total parameters).
	 */
	@SuppressWarnings("unchecked")
	public T maxParameters(Integer value) {
		this.maxParameters = value;
		return (T) this;
	}

	/**
	 * The maximum size of a post that will be accepted
	 */
	@ModelNodeBinding(detypedName = "max-post-size")
	public Long maxPostSize() {
		return this.maxPostSize;
	}

	/**
	 * The maximum size of a post that will be accepted
	 */
	@SuppressWarnings("unchecked")
	public T maxPostSize(Long value) {
		this.maxPostSize = value;
		return (T) this;
	}

	/**
	 * The maximum processing time taken by a request on this listener
	 */
	@ModelNodeBinding(detypedName = "max-processing-time")
	public Long maxProcessingTime() {
		return this.maxProcessingTime;
	}

	/**
	 * The maximum processing time taken by a request on this listener
	 */
	@SuppressWarnings("unchecked")
	public T maxProcessingTime(Long value) {
		this.maxProcessingTime = value;
		return (T) this;
	}

	/**
	 * The length of time in milliseconds that the connection can be idle before it is closed by the container
	 */
	@ModelNodeBinding(detypedName = "no-request-timeout")
	public Integer noRequestTimeout() {
		return this.noRequestTimeout;
	}

	/**
	 * The length of time in milliseconds that the connection can be idle before it is closed by the container
	 */
	@SuppressWarnings("unchecked")
	public T noRequestTimeout(Integer value) {
		this.noRequestTimeout = value;
		return (T) this;
	}

	/**
	 * The total processing time of all requests handed by this listener
	 */
	@ModelNodeBinding(detypedName = "processing-time")
	public Long processingTime() {
		return this.processingTime;
	}

	/**
	 * The total processing time of all requests handed by this listener
	 */
	@SuppressWarnings("unchecked")
	public T processingTime(Long value) {
		this.processingTime = value;
		return (T) this;
	}

	/**
	 * Configure a read timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful read taking place, the socket's next read will throw a {@link ReadTimeoutException}.
	 */
	@ModelNodeBinding(detypedName = "read-timeout")
	public Integer readTimeout() {
		return this.readTimeout;
	}

	/**
	 * Configure a read timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful read taking place, the socket's next read will throw a {@link ReadTimeoutException}.
	 */
	@SuppressWarnings("unchecked")
	public T readTimeout(Integer value) {
		this.readTimeout = value;
		return (T) this;
	}

	/**
	 * The receive buffer size.
	 */
	@ModelNodeBinding(detypedName = "receive-buffer")
	public Integer receiveBuffer() {
		return this.receiveBuffer;
	}

	/**
	 * The receive buffer size.
	 */
	@SuppressWarnings("unchecked")
	public T receiveBuffer(Integer value) {
		this.receiveBuffer = value;
		return (T) this;
	}

	/**
	 * If this is true then Undertow will record the request start time, to allow for request time to be logged. This has a small but measurable performance impact
	 */
	@ModelNodeBinding(detypedName = "record-request-start-time")
	public Boolean recordRequestStartTime() {
		return this.recordRequestStartTime;
	}

	/**
	 * If this is true then Undertow will record the request start time, to allow for request time to be logged. This has a small but measurable performance impact
	 */
	@SuppressWarnings("unchecked")
	public T recordRequestStartTime(Boolean value) {
		this.recordRequestStartTime = value;
		return (T) this;
	}

	/**
	 * The number of requests this listener has served
	 */
	@ModelNodeBinding(detypedName = "request-count")
	public Long requestCount() {
		return this.requestCount;
	}

	/**
	 * The number of requests this listener has served
	 */
	@SuppressWarnings("unchecked")
	public T requestCount(Long value) {
		this.requestCount = value;
		return (T) this;
	}

	/**
	 * The maximum amount of time (in milliseconds) that can be spent parsing the request
	 */
	@ModelNodeBinding(detypedName = "request-parse-timeout")
	public Integer requestParseTimeout() {
		return this.requestParseTimeout;
	}

	/**
	 * The maximum amount of time (in milliseconds) that can be spent parsing the request
	 */
	@SuppressWarnings("unchecked")
	public T requestParseTimeout(Integer value) {
		this.requestParseTimeout = value;
		return (T) this;
	}

	/**
	 * Enables host dns lookup
	 */
	@ModelNodeBinding(detypedName = "resolve-peer-address")
	public Boolean resolvePeerAddress() {
		return this.resolvePeerAddress;
	}

	/**
	 * Enables host dns lookup
	 */
	@SuppressWarnings("unchecked")
	public T resolvePeerAddress(Boolean value) {
		this.resolvePeerAddress = value;
		return (T) this;
	}

	/**
	 * The listeners security realm
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The listeners security realm
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(String value) {
		this.securityRealm = value;
		return (T) this;
	}

	/**
	 * The send buffer size.
	 */
	@ModelNodeBinding(detypedName = "send-buffer")
	public Integer sendBuffer() {
		return this.sendBuffer;
	}

	/**
	 * The send buffer size.
	 */
	@SuppressWarnings("unchecked")
	public T sendBuffer(Integer value) {
		this.sendBuffer = value;
		return (T) this;
	}

	/**
	 * The AJP listener socket binder
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The AJP listener socket binder
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		this.socketBinding = value;
		return (T) this;
	}

	/**
	 * The maximum number of active SSL sessions
	 */
	@ModelNodeBinding(detypedName = "ssl-session-cache-size")
	public Integer sslSessionCacheSize() {
		return this.sslSessionCacheSize;
	}

	/**
	 * The maximum number of active SSL sessions
	 */
	@SuppressWarnings("unchecked")
	public T sslSessionCacheSize(Integer value) {
		this.sslSessionCacheSize = value;
		return (T) this;
	}

	/**
	 * The timeout for SSL sessions, in seconds
	 */
	@ModelNodeBinding(detypedName = "ssl-session-timeout")
	public Integer sslSessionTimeout() {
		return this.sslSessionTimeout;
	}

	/**
	 * The timeout for SSL sessions, in seconds
	 */
	@SuppressWarnings("unchecked")
	public T sslSessionTimeout(Integer value) {
		this.sslSessionTimeout = value;
		return (T) this;
	}

	/**
	 * Configure a server with the specified backlog.
	 */
	@ModelNodeBinding(detypedName = "tcp-backlog")
	public Integer tcpBacklog() {
		return this.tcpBacklog;
	}

	/**
	 * Configure a server with the specified backlog.
	 */
	@SuppressWarnings("unchecked")
	public T tcpBacklog(Integer value) {
		this.tcpBacklog = value;
		return (T) this;
	}

	/**
	 * Configure a channel to send TCP keep-alive messages in an implementation-dependent manner.
	 */
	@ModelNodeBinding(detypedName = "tcp-keep-alive")
	public Boolean tcpKeepAlive() {
		return this.tcpKeepAlive;
	}

	/**
	 * Configure a channel to send TCP keep-alive messages in an implementation-dependent manner.
	 */
	@SuppressWarnings("unchecked")
	public T tcpKeepAlive(Boolean value) {
		this.tcpKeepAlive = value;
		return (T) this;
	}

	/**
	 * URL charset
	 */
	@ModelNodeBinding(detypedName = "url-charset")
	public String urlCharset() {
		return this.urlCharset;
	}

	/**
	 * URL charset
	 */
	@SuppressWarnings("unchecked")
	public T urlCharset(String value) {
		this.urlCharset = value;
		return (T) this;
	}

	/**
	 * The desired SSL client authentication mode for SSL channels
	 */
	@ModelNodeBinding(detypedName = "verify-client")
	public String verifyClient() {
		return this.verifyClient;
	}

	/**
	 * The desired SSL client authentication mode for SSL channels
	 */
	@SuppressWarnings("unchecked")
	public T verifyClient(String value) {
		this.verifyClient = value;
		return (T) this;
	}

	/**
	 * The AJP listeners XNIO worker
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * The AJP listeners XNIO worker
	 */
	@SuppressWarnings("unchecked")
	public T worker(String value) {
		this.worker = value;
		return (T) this;
	}

	/**
	 * Configure a write timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful write taking place, the socket's next write will throw a {@link WriteTimeoutException}.
	 */
	@ModelNodeBinding(detypedName = "write-timeout")
	public Integer writeTimeout() {
		return this.writeTimeout;
	}

	/**
	 * Configure a write timeout for a socket, in milliseconds.  If the given amount of time elapses without a successful write taking place, the socket's next write will throw a {@link WriteTimeoutException}.
	 */
	@SuppressWarnings("unchecked")
	public T writeTimeout(Integer value) {
		this.writeTimeout = value;
		return (T) this;
	}
}