package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * JSP container configuration.
 */
@ResourceType("setting")
@Implicit
public class JSPSetting<T extends JSPSetting> {

	private String key;
	private Integer checkInterval;
	private Boolean development;
	private Boolean disabled;
	private Boolean displaySourceFragment;
	private Boolean dumpSmap;
	private Boolean errorOnUseBeanInvalidClassAttribute;
	private Boolean generateStringsAsCharArrays;
	private String javaEncoding;
	private Boolean keepGenerated;
	private Boolean mappedFile;
	private Integer modificationTestInterval;
	private Boolean optimizeScriptlets;
	private Boolean recompileOnFail;
	private String scratchDir;
	private Boolean smap;
	private String sourceVm;
	private Boolean tagPooling;
	private String targetVm;
	private Boolean trimSpaces;
	private Boolean xPoweredBy;

	public JSPSetting() {
		this.key = "jsp";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Check interval for JSP updates using a background thread.
	 */
	@ModelNodeBinding(detypedName = "check-interval")
	public Integer checkInterval() {
		return this.checkInterval;
	}

	/**
	 * Check interval for JSP updates using a background thread.
	 */
	@SuppressWarnings("unchecked")
	public T checkInterval(Integer value) {
		this.checkInterval = value;
		return (T) this;
	}

	/**
	 * Enable Development mode which enables reloading JSP on-the-fly
	 */
	@ModelNodeBinding(detypedName = "development")
	public Boolean development() {
		return this.development;
	}

	/**
	 * Enable Development mode which enables reloading JSP on-the-fly
	 */
	@SuppressWarnings("unchecked")
	public T development(Boolean value) {
		this.development = value;
		return (T) this;
	}

	/**
	 * Enable the JSP container.
	 */
	@ModelNodeBinding(detypedName = "disabled")
	public Boolean disabled() {
		return this.disabled;
	}

	/**
	 * Enable the JSP container.
	 */
	@SuppressWarnings("unchecked")
	public T disabled(Boolean value) {
		this.disabled = value;
		return (T) this;
	}

	/**
	 * When a runtime error occurs, attempts to display corresponding JSP source fragment
	 */
	@ModelNodeBinding(detypedName = "display-source-fragment")
	public Boolean displaySourceFragment() {
		return this.displaySourceFragment;
	}

	/**
	 * When a runtime error occurs, attempts to display corresponding JSP source fragment
	 */
	@SuppressWarnings("unchecked")
	public T displaySourceFragment(Boolean value) {
		this.displaySourceFragment = value;
		return (T) this;
	}

	/**
	 * Write SMAP data to a file.
	 */
	@ModelNodeBinding(detypedName = "dump-smap")
	public Boolean dumpSmap() {
		return this.dumpSmap;
	}

	/**
	 * Write SMAP data to a file.
	 */
	@SuppressWarnings("unchecked")
	public T dumpSmap(Boolean value) {
		this.dumpSmap = value;
		return (T) this;
	}

	/**
	 * Enable errors when using a bad class in useBean.
	 */
	@ModelNodeBinding(detypedName = "error-on-use-bean-invalid-class-attribute")
	public Boolean errorOnUseBeanInvalidClassAttribute() {
		return this.errorOnUseBeanInvalidClassAttribute;
	}

	/**
	 * Enable errors when using a bad class in useBean.
	 */
	@SuppressWarnings("unchecked")
	public T errorOnUseBeanInvalidClassAttribute(Boolean value) {
		this.errorOnUseBeanInvalidClassAttribute = value;
		return (T) this;
	}

	/**
	 * Generate String constants as char arrays.
	 */
	@ModelNodeBinding(detypedName = "generate-strings-as-char-arrays")
	public Boolean generateStringsAsCharArrays() {
		return this.generateStringsAsCharArrays;
	}

	/**
	 * Generate String constants as char arrays.
	 */
	@SuppressWarnings("unchecked")
	public T generateStringsAsCharArrays(Boolean value) {
		this.generateStringsAsCharArrays = value;
		return (T) this;
	}

	/**
	 * Specify the encoding used for Java sources.
	 */
	@ModelNodeBinding(detypedName = "java-encoding")
	public String javaEncoding() {
		return this.javaEncoding;
	}

	/**
	 * Specify the encoding used for Java sources.
	 */
	@SuppressWarnings("unchecked")
	public T javaEncoding(String value) {
		this.javaEncoding = value;
		return (T) this;
	}

	/**
	 * Keep the generated Servlets.
	 */
	@ModelNodeBinding(detypedName = "keep-generated")
	public Boolean keepGenerated() {
		return this.keepGenerated;
	}

	/**
	 * Keep the generated Servlets.
	 */
	@SuppressWarnings("unchecked")
	public T keepGenerated(Boolean value) {
		this.keepGenerated = value;
		return (T) this;
	}

	/**
	 * Map to the JSP source.
	 */
	@ModelNodeBinding(detypedName = "mapped-file")
	public Boolean mappedFile() {
		return this.mappedFile;
	}

	/**
	 * Map to the JSP source.
	 */
	@SuppressWarnings("unchecked")
	public T mappedFile(Boolean value) {
		this.mappedFile = value;
		return (T) this;
	}

	/**
	 * Minimum amount of time between two tests for updates, in seconds.
	 */
	@ModelNodeBinding(detypedName = "modification-test-interval")
	public Integer modificationTestInterval() {
		return this.modificationTestInterval;
	}

	/**
	 * Minimum amount of time between two tests for updates, in seconds.
	 */
	@SuppressWarnings("unchecked")
	public T modificationTestInterval(Integer value) {
		this.modificationTestInterval = value;
		return (T) this;
	}

	/**
	 * If JSP scriptlets should be optimised to remove string concatenation
	 */
	@ModelNodeBinding(detypedName = "optimize-scriptlets")
	public Boolean optimizeScriptlets() {
		return this.optimizeScriptlets;
	}

	/**
	 * If JSP scriptlets should be optimised to remove string concatenation
	 */
	@SuppressWarnings("unchecked")
	public T optimizeScriptlets(Boolean value) {
		this.optimizeScriptlets = value;
		return (T) this;
	}

	/**
	 * Retry failed JSP compilations on each request.
	 */
	@ModelNodeBinding(detypedName = "recompile-on-fail")
	public Boolean recompileOnFail() {
		return this.recompileOnFail;
	}

	/**
	 * Retry failed JSP compilations on each request.
	 */
	@SuppressWarnings("unchecked")
	public T recompileOnFail(Boolean value) {
		this.recompileOnFail = value;
		return (T) this;
	}

	/**
	 * Specify a different work directory.
	 */
	@ModelNodeBinding(detypedName = "scratch-dir")
	public String scratchDir() {
		return this.scratchDir;
	}

	/**
	 * Specify a different work directory.
	 */
	@SuppressWarnings("unchecked")
	public T scratchDir(String value) {
		this.scratchDir = value;
		return (T) this;
	}

	/**
	 * Enable SMAP.
	 */
	@ModelNodeBinding(detypedName = "smap")
	public Boolean smap() {
		return this.smap;
	}

	/**
	 * Enable SMAP.
	 */
	@SuppressWarnings("unchecked")
	public T smap(Boolean value) {
		this.smap = value;
		return (T) this;
	}

	/**
	 * Source VM level for compilation.
	 */
	@ModelNodeBinding(detypedName = "source-vm")
	public String sourceVm() {
		return this.sourceVm;
	}

	/**
	 * Source VM level for compilation.
	 */
	@SuppressWarnings("unchecked")
	public T sourceVm(String value) {
		this.sourceVm = value;
		return (T) this;
	}

	/**
	 * Enable tag pooling.
	 */
	@ModelNodeBinding(detypedName = "tag-pooling")
	public Boolean tagPooling() {
		return this.tagPooling;
	}

	/**
	 * Enable tag pooling.
	 */
	@SuppressWarnings("unchecked")
	public T tagPooling(Boolean value) {
		this.tagPooling = value;
		return (T) this;
	}

	/**
	 * Target VM level for compilation.
	 */
	@ModelNodeBinding(detypedName = "target-vm")
	public String targetVm() {
		return this.targetVm;
	}

	/**
	 * Target VM level for compilation.
	 */
	@SuppressWarnings("unchecked")
	public T targetVm(String value) {
		this.targetVm = value;
		return (T) this;
	}

	/**
	 * Trim some spaces from the generated Servlet.
	 */
	@ModelNodeBinding(detypedName = "trim-spaces")
	public Boolean trimSpaces() {
		return this.trimSpaces;
	}

	/**
	 * Trim some spaces from the generated Servlet.
	 */
	@SuppressWarnings("unchecked")
	public T trimSpaces(Boolean value) {
		this.trimSpaces = value;
		return (T) this;
	}

	/**
	 * Enable advertising the JSP engine in x-powered-by.
	 */
	@ModelNodeBinding(detypedName = "x-powered-by")
	public Boolean xPoweredBy() {
		return this.xPoweredBy;
	}

	/**
	 * Enable advertising the JSP engine in x-powered-by.
	 */
	@SuppressWarnings("unchecked")
	public T xPoweredBy(Boolean value) {
		this.xPoweredBy = value;
		return (T) this;
	}
}