package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Session persistence sessions
 */
@ResourceType("setting")
@Implicit
public class PersistentSessionsSetting<T extends PersistentSessionsSetting> {

	private String key;
	private String path;
	private String relativeTo;

	public PersistentSessionsSetting() {
		this.key = "persistent-sessions";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The path to the persistent session data directory. If this is null sessions will be stored in memory
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path to the persistent session data directory. If this is null sessions will be stored in memory
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		this.path = value;
		return (T) this;
	}

	/**
	 * The directory the path is relative to
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The directory the path is relative to
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(String value) {
		this.relativeTo = value;
		return (T) this;
	}
}