package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Session cookie configuration
 */
@ResourceType("setting")
@Implicit
public class SessionCookieSetting<T extends SessionCookieSetting> {

	private String key;
	private String comment;
	private String domain;
	private Boolean httpOnly;
	private Integer maxAge;
	private String name;
	private Boolean secure;

	public SessionCookieSetting() {
		this.key = "session-cookie";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Cookie comment
	 */
	@ModelNodeBinding(detypedName = "comment")
	public String comment() {
		return this.comment;
	}

	/**
	 * Cookie comment
	 */
	@SuppressWarnings("unchecked")
	public T comment(String value) {
		this.comment = value;
		return (T) this;
	}

	/**
	 * Cookie domain
	 */
	@ModelNodeBinding(detypedName = "domain")
	public String domain() {
		return this.domain;
	}

	/**
	 * Cookie domain
	 */
	@SuppressWarnings("unchecked")
	public T domain(String value) {
		this.domain = value;
		return (T) this;
	}

	/**
	 * Is cookie http-only
	 */
	@ModelNodeBinding(detypedName = "http-only")
	public Boolean httpOnly() {
		return this.httpOnly;
	}

	/**
	 * Is cookie http-only
	 */
	@SuppressWarnings("unchecked")
	public T httpOnly(Boolean value) {
		this.httpOnly = value;
		return (T) this;
	}

	/**
	 * Max age of cookie
	 */
	@ModelNodeBinding(detypedName = "max-age")
	public Integer maxAge() {
		return this.maxAge;
	}

	/**
	 * Max age of cookie
	 */
	@SuppressWarnings("unchecked")
	public T maxAge(Integer value) {
		this.maxAge = value;
		return (T) this;
	}

	/**
	 * Name of the cookie
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * Name of the cookie
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		this.name = value;
		return (T) this;
	}

	/**
	 * Is cookie secure?
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * Is cookie secure?
	 */
	@SuppressWarnings("unchecked")
	public T secure(Boolean value) {
		this.secure = value;
		return (T) this;
	}
}