/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.datasources.DataSource;
import org.wildfly.swarm.config.datasources.DataSourceConfigurator;
import org.wildfly.swarm.config.datasources.JDBCDriver;
import org.wildfly.swarm.config.datasources.JDBCDriverConfigurator;
import org.wildfly.swarm.config.datasources.XADataSource;
import org.wildfly.swarm.config.datasources.XADataSourceConfigurator;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="subsystem")
@Implicit
public class Datasources<T extends Datasources> {
    private String key = "datasources";
    private List<Map> installedDrivers;
    private DatasourcesResources subresources = new DatasourcesResources();

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="installed-drivers")
    public List<Map> installedDrivers() {
        return this.installedDrivers;
    }

    public T installedDrivers(List<Map> value) {
        this.installedDrivers = value;
        return (T)this;
    }

    public T installedDriver(Map value) {
        if (this.installedDrivers == null) {
            this.installedDrivers = new ArrayList<Map>();
        }
        this.installedDrivers.add(value);
        return (T)this;
    }

    public DatasourcesResources subresources() {
        return this.subresources;
    }

    public T jdbcDrivers(List<JDBCDriver> value) {
        this.subresources.jdbcDrivers = value;
        return (T)this;
    }

    public T jdbcDriver(JDBCDriver value) {
        this.subresources.jdbcDrivers.add(value);
        return (T)this;
    }

    public T jdbcDriver(String childKey, JDBCDriverConfigurator config) {
        JDBCDriver child = new JDBCDriver(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.jdbcDriver(child);
        return (T)this;
    }

    public T jdbcDriver(String childKey) {
        this.jdbcDriver(childKey, null);
        return (T)this;
    }

    public T xaDataSources(List<XADataSource> value) {
        this.subresources.xaDataSources = value;
        return (T)this;
    }

    public T xaDataSource(XADataSource value) {
        this.subresources.xaDataSources.add(value);
        return (T)this;
    }

    public T xaDataSource(String childKey, XADataSourceConfigurator config) {
        XADataSource child = new XADataSource(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.xaDataSource(child);
        return (T)this;
    }

    public T xaDataSource(String childKey) {
        this.xaDataSource(childKey, null);
        return (T)this;
    }

    public T dataSources(List<DataSource> value) {
        this.subresources.dataSources = value;
        return (T)this;
    }

    public T dataSource(DataSource value) {
        this.subresources.dataSources.add(value);
        return (T)this;
    }

    public T dataSource(String childKey, DataSourceConfigurator config) {
        DataSource child = new DataSource(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.dataSource(child);
        return (T)this;
    }

    public T dataSource(String childKey) {
        this.dataSource(childKey, null);
        return (T)this;
    }

    public class DatasourcesResources {
        private List<JDBCDriver> jdbcDrivers = new ArrayList<JDBCDriver>();
        private List<XADataSource> xaDataSources = new ArrayList<XADataSource>();
        private List<DataSource> dataSources = new ArrayList<DataSource>();

        @Subresource
        public List<JDBCDriver> jdbcDrivers() {
            return this.jdbcDrivers;
        }

        @Subresource
        public List<XADataSource> xaDataSources() {
            return this.xaDataSources;
        }

        @Subresource
        public List<DataSource> dataSources() {
            return this.dataSources;
        }
    }
}

