/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.mail;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.mail.mail_session.Custom;
import org.wildfly.swarm.config.mail.mail_session.CustomConfigurator;
import org.wildfly.swarm.config.mail.mail_session.IMAPServer;
import org.wildfly.swarm.config.mail.mail_session.POP3Server;
import org.wildfly.swarm.config.mail.mail_session.SMTPServer;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="mail-session")
public class MailSession<T extends MailSession> {
    private String key;
    private Boolean debug;
    private String from;
    private String jndiName;
    private MailSessionResources subresources = new MailSessionResources();
    private POP3Server pop3Server;
    private SMTPServer smtpServer;
    private IMAPServer imapServer;

    public MailSession(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="debug")
    public Boolean debug() {
        return this.debug;
    }

    public T debug(Boolean value) {
        this.debug = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="from")
    public String from() {
        return this.from;
    }

    public T from(String value) {
        this.from = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        this.jndiName = value;
        return (T)this;
    }

    public MailSessionResources subresources() {
        return this.subresources;
    }

    public T customs(List<Custom> value) {
        this.subresources.customs = value;
        return (T)this;
    }

    public T custom(Custom value) {
        this.subresources.customs.add(value);
        return (T)this;
    }

    public T custom(String childKey, CustomConfigurator config) {
        Custom child = new Custom(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.custom(child);
        return (T)this;
    }

    public T custom(String childKey) {
        this.custom(childKey, null);
        return (T)this;
    }

    @Subresource
    public POP3Server pop3Server() {
        return this.pop3Server;
    }

    public T pop3Server(POP3Server value) {
        this.pop3Server = value;
        return (T)this;
    }

    @Subresource
    public SMTPServer smtpServer() {
        return this.smtpServer;
    }

    public T smtpServer(SMTPServer value) {
        this.smtpServer = value;
        return (T)this;
    }

    @Subresource
    public IMAPServer imapServer() {
        return this.imapServer;
    }

    public T imapServer(IMAPServer value) {
        this.imapServer = value;
        return (T)this;
    }

    public class MailSessionResources {
        private List<Custom> customs = new ArrayList<Custom>();

        @Subresource
        public List<Custom> customs() {
            return this.customs;
        }
    }
}

