/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PropertyConfigurator;
import org.wildfly.swarm.config.remoting.SASLSecurity;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="http-connector")
public class HTTPConnector<T extends HTTPConnector> {
    private String key;
    private String authenticationProvider;
    private String connectorRef;
    private String saslProtocol;
    private String securityRealm;
    private String serverName;
    private HTTPConnectorResources subresources = new HTTPConnectorResources();
    private SASLSecurity saslSecurity;

    public HTTPConnector(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="authentication-provider")
    public String authenticationProvider() {
        return this.authenticationProvider;
    }

    public T authenticationProvider(String value) {
        this.authenticationProvider = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connector-ref")
    public String connectorRef() {
        return this.connectorRef;
    }

    public T connectorRef(String value) {
        this.connectorRef = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-protocol")
    public String saslProtocol() {
        return this.saslProtocol;
    }

    public T saslProtocol(String value) {
        this.saslProtocol = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        this.securityRealm = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        this.serverName = value;
        return (T)this;
    }

    public HTTPConnectorResources subresources() {
        return this.subresources;
    }

    public T propertys(List<Property> value) {
        this.subresources.propertys = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.propertys.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConfigurator config) {
        Property child = new Property(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    @Subresource
    public SASLSecurity saslSecurity() {
        return this.saslSecurity;
    }

    public T saslSecurity(SASLSecurity value) {
        this.saslSecurity = value;
        return (T)this;
    }

    public class HTTPConnectorResources {
        private List<Property> propertys = new ArrayList<Property>();

        @Subresource
        public List<Property> propertys() {
            return this.propertys;
        }
    }
}

