/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModule;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModuleConfigurator;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStackConfigurator;

@ResourceType(value="authentication")
@Implicit
public class JaspiAuthentication<T extends JaspiAuthentication> {
    private String key = "jaspi";
    private JaspiAuthenticationResources subresources = new JaspiAuthenticationResources();

    public String getKey() {
        return this.key;
    }

    public JaspiAuthenticationResources subresources() {
        return this.subresources;
    }

    public T loginModuleStacks(List<LoginModuleStack> value) {
        this.subresources.loginModuleStacks = value;
        return (T)this;
    }

    public T loginModuleStack(LoginModuleStack value) {
        this.subresources.loginModuleStacks.add(value);
        return (T)this;
    }

    public T loginModuleStack(String childKey, LoginModuleStackConfigurator config) {
        LoginModuleStack child = new LoginModuleStack(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.loginModuleStack(child);
        return (T)this;
    }

    public T loginModuleStack(String childKey) {
        this.loginModuleStack(childKey, null);
        return (T)this;
    }

    public T authModules(List<AuthModule> value) {
        this.subresources.authModules = value;
        return (T)this;
    }

    public T authModule(AuthModule value) {
        this.subresources.authModules.add(value);
        return (T)this;
    }

    public T authModule(String childKey, AuthModuleConfigurator config) {
        AuthModule child = new AuthModule(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.authModule(child);
        return (T)this;
    }

    public T authModule(String childKey) {
        this.authModule(childKey, null);
        return (T)this;
    }

    public class JaspiAuthenticationResources {
        private List<LoginModuleStack> loginModuleStacks = new ArrayList<LoginModuleStack>();
        private List<AuthModule> authModules = new ArrayList<AuthModule>();

        @Subresource
        public List<LoginModuleStack> loginModuleStacks() {
            return this.loginModuleStacks;
        }

        @Subresource
        public List<AuthModule> authModules() {
            return this.authModules;
        }
    }
}

