/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain.authentication;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleConfigurator;

@ResourceType(value="login-module-stack")
public class LoginModuleStack<T extends LoginModuleStack> {
    private String key;
    private LoginModuleStackResources subresources = new LoginModuleStackResources();

    public LoginModuleStack(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public LoginModuleStackResources subresources() {
        return this.subresources;
    }

    public T loginModules(List<LoginModule> value) {
        this.subresources.loginModules = value;
        return (T)this;
    }

    public T loginModule(LoginModule value) {
        this.subresources.loginModules.add(value);
        return (T)this;
    }

    public T loginModule(String childKey, LoginModuleConfigurator config) {
        LoginModule child = new LoginModule(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.loginModule(child);
        return (T)this;
    }

    public T loginModule(String childKey) {
        this.loginModule(childKey, null);
        return (T)this;
    }

    public class LoginModuleStackResources {
        private List<LoginModule> loginModules = new ArrayList<LoginModule>();

        @Subresource
        public List<LoginModule> loginModules() {
            return this.loginModules;
        }
    }
}

