/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSetting;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMapping;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMappingConfigurator;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileConfigurator;

@ResourceType(value="servlet-container")
public class ServletContainer<T extends ServletContainer> {
    private String key;
    private Boolean allowNonStandardWrappers;
    private String defaultBufferCache;
    private String defaultEncoding;
    private Integer defaultSessionTimeout;
    private Boolean directoryListing;
    private Boolean disableCachingForSecuredPages;
    private Boolean eagerFilterInitialization;
    private Boolean ignoreFlush;
    private Integer maxSessions;
    private Boolean proactiveAuthentication;
    private Integer sessionIdLength;
    private String stackTraceOnError;
    private Boolean useListenerEncoding;
    private ServletContainerResources subresources = new ServletContainerResources();
    private PersistentSessionsSetting persistentSessionsSetting;
    private JSPSetting jspSetting;
    private WebsocketsSetting websocketsSetting;
    private SessionCookieSetting sessionCookieSetting;

    public ServletContainer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="allow-non-standard-wrappers")
    public Boolean allowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public T allowNonStandardWrappers(Boolean value) {
        this.allowNonStandardWrappers = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-buffer-cache")
    public String defaultBufferCache() {
        return this.defaultBufferCache;
    }

    public T defaultBufferCache(String value) {
        this.defaultBufferCache = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-encoding")
    public String defaultEncoding() {
        return this.defaultEncoding;
    }

    public T defaultEncoding(String value) {
        this.defaultEncoding = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-session-timeout")
    public Integer defaultSessionTimeout() {
        return this.defaultSessionTimeout;
    }

    public T defaultSessionTimeout(Integer value) {
        this.defaultSessionTimeout = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="directory-listing")
    public Boolean directoryListing() {
        return this.directoryListing;
    }

    public T directoryListing(Boolean value) {
        this.directoryListing = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="disable-caching-for-secured-pages")
    public Boolean disableCachingForSecuredPages() {
        return this.disableCachingForSecuredPages;
    }

    public T disableCachingForSecuredPages(Boolean value) {
        this.disableCachingForSecuredPages = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="eager-filter-initialization")
    public Boolean eagerFilterInitialization() {
        return this.eagerFilterInitialization;
    }

    public T eagerFilterInitialization(Boolean value) {
        this.eagerFilterInitialization = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="ignore-flush")
    public Boolean ignoreFlush() {
        return this.ignoreFlush;
    }

    public T ignoreFlush(Boolean value) {
        this.ignoreFlush = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-sessions")
    public Integer maxSessions() {
        return this.maxSessions;
    }

    public T maxSessions(Integer value) {
        this.maxSessions = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="proactive-authentication")
    public Boolean proactiveAuthentication() {
        return this.proactiveAuthentication;
    }

    public T proactiveAuthentication(Boolean value) {
        this.proactiveAuthentication = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="session-id-length")
    public Integer sessionIdLength() {
        return this.sessionIdLength;
    }

    public T sessionIdLength(Integer value) {
        this.sessionIdLength = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="stack-trace-on-error")
    public String stackTraceOnError() {
        return this.stackTraceOnError;
    }

    public T stackTraceOnError(String value) {
        this.stackTraceOnError = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-listener-encoding")
    public Boolean useListenerEncoding() {
        return this.useListenerEncoding;
    }

    public T useListenerEncoding(Boolean value) {
        this.useListenerEncoding = value;
        return (T)this;
    }

    public ServletContainerResources subresources() {
        return this.subresources;
    }

    public T mimeMappings(List<MimeMapping> value) {
        this.subresources.mimeMappings = value;
        return (T)this;
    }

    public T mimeMapping(MimeMapping value) {
        this.subresources.mimeMappings.add(value);
        return (T)this;
    }

    public T mimeMapping(String childKey, MimeMappingConfigurator config) {
        MimeMapping child = new MimeMapping(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.mimeMapping(child);
        return (T)this;
    }

    public T mimeMapping(String childKey) {
        this.mimeMapping(childKey, null);
        return (T)this;
    }

    public T welcomeFiles(List<WelcomeFile> value) {
        this.subresources.welcomeFiles = value;
        return (T)this;
    }

    public T welcomeFile(WelcomeFile value) {
        this.subresources.welcomeFiles.add(value);
        return (T)this;
    }

    public T welcomeFile(String childKey, WelcomeFileConfigurator config) {
        WelcomeFile child = new WelcomeFile(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.welcomeFile(child);
        return (T)this;
    }

    public T welcomeFile(String childKey) {
        this.welcomeFile(childKey, null);
        return (T)this;
    }

    @Subresource
    public PersistentSessionsSetting persistentSessionsSetting() {
        return this.persistentSessionsSetting;
    }

    public T persistentSessionsSetting(PersistentSessionsSetting value) {
        this.persistentSessionsSetting = value;
        return (T)this;
    }

    @Subresource
    public JSPSetting jspSetting() {
        return this.jspSetting;
    }

    public T jspSetting(JSPSetting value) {
        this.jspSetting = value;
        return (T)this;
    }

    @Subresource
    public WebsocketsSetting websocketsSetting() {
        return this.websocketsSetting;
    }

    public T websocketsSetting(WebsocketsSetting value) {
        this.websocketsSetting = value;
        return (T)this;
    }

    @Subresource
    public SessionCookieSetting sessionCookieSetting() {
        return this.sessionCookieSetting;
    }

    public T sessionCookieSetting(SessionCookieSetting value) {
        this.sessionCookieSetting = value;
        return (T)this;
    }

    public class ServletContainerResources {
        private List<MimeMapping> mimeMappings = new ArrayList<MimeMapping>();
        private List<WelcomeFile> welcomeFiles = new ArrayList<WelcomeFile>();

        @Subresource
        public List<MimeMapping> mimeMappings() {
            return this.mimeMappings;
        }

        @Subresource
        public List<WelcomeFile> welcomeFiles() {
            return this.welcomeFiles;
        }
    }
}

