/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.Balancer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerConfigurator;

@ResourceType(value="mod-cluster")
public class ModCluster<T extends ModCluster> {
    private String key;
    private Integer advertiseFrequency;
    private String advertisePath;
    private String advertiseProtocol;
    private String advertiseSocketBinding;
    private Integer brokenNodeTimeout;
    private Integer cachedConnectionsPerThread;
    private Integer connectionIdleTimeout;
    private Integer connectionsPerThread;
    private Integer healthCheckInterval;
    private String managementAccessPredicate;
    private String managementSocketBinding;
    private Integer maxRequestTime;
    private Integer requestQueueSize;
    private String securityKey;
    private String securityRealm;
    private Boolean useAlias;
    private String worker;
    private ModClusterResources subresources = new ModClusterResources();

    public ModCluster(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="advertise-frequency")
    public Integer advertiseFrequency() {
        return this.advertiseFrequency;
    }

    public T advertiseFrequency(Integer value) {
        this.advertiseFrequency = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-path")
    public String advertisePath() {
        return this.advertisePath;
    }

    public T advertisePath(String value) {
        this.advertisePath = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-protocol")
    public String advertiseProtocol() {
        return this.advertiseProtocol;
    }

    public T advertiseProtocol(String value) {
        this.advertiseProtocol = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="advertise-socket-binding")
    public String advertiseSocketBinding() {
        return this.advertiseSocketBinding;
    }

    public T advertiseSocketBinding(String value) {
        this.advertiseSocketBinding = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="broken-node-timeout")
    public Integer brokenNodeTimeout() {
        return this.brokenNodeTimeout;
    }

    public T brokenNodeTimeout(Integer value) {
        this.brokenNodeTimeout = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cached-connections-per-thread")
    public Integer cachedConnectionsPerThread() {
        return this.cachedConnectionsPerThread;
    }

    public T cachedConnectionsPerThread(Integer value) {
        this.cachedConnectionsPerThread = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connection-idle-timeout")
    public Integer connectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public T connectionIdleTimeout(Integer value) {
        this.connectionIdleTimeout = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connections-per-thread")
    public Integer connectionsPerThread() {
        return this.connectionsPerThread;
    }

    public T connectionsPerThread(Integer value) {
        this.connectionsPerThread = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="health-check-interval")
    public Integer healthCheckInterval() {
        return this.healthCheckInterval;
    }

    public T healthCheckInterval(Integer value) {
        this.healthCheckInterval = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-access-predicate")
    public String managementAccessPredicate() {
        return this.managementAccessPredicate;
    }

    public T managementAccessPredicate(String value) {
        this.managementAccessPredicate = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="management-socket-binding")
    public String managementSocketBinding() {
        return this.managementSocketBinding;
    }

    public T managementSocketBinding(String value) {
        this.managementSocketBinding = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="max-request-time")
    public Integer maxRequestTime() {
        return this.maxRequestTime;
    }

    public T maxRequestTime(Integer value) {
        this.maxRequestTime = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public T requestQueueSize(Integer value) {
        this.requestQueueSize = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-key")
    public String securityKey() {
        return this.securityKey;
    }

    public T securityKey(String value) {
        this.securityKey = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        this.securityRealm = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-alias")
    public Boolean useAlias() {
        return this.useAlias;
    }

    public T useAlias(Boolean value) {
        this.useAlias = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="worker")
    public String worker() {
        return this.worker;
    }

    public T worker(String value) {
        this.worker = value;
        return (T)this;
    }

    public ModClusterResources subresources() {
        return this.subresources;
    }

    public T balancers(List<Balancer> value) {
        this.subresources.balancers = value;
        return (T)this;
    }

    public T balancer(Balancer value) {
        this.subresources.balancers.add(value);
        return (T)this;
    }

    public T balancer(String childKey, BalancerConfigurator config) {
        Balancer child = new Balancer(childKey);
        if (config != null) {
            config.configure(child);
        }
        this.balancer(child);
        return (T)this;
    }

    public T balancer(String childKey) {
        this.balancer(childKey, null);
        return (T)this;
    }

    public class ModClusterResources {
        private List<Balancer> balancers = new ArrayList<Balancer>();

        @Subresource
        public List<Balancer> balancers() {
            return this.balancers;
        }
    }
}

