package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.jca.DistributedWorkmanagerConsumer;
import org.wildfly.swarm.config.jca.DistributedWorkmanagerSupplier;
import org.wildfly.swarm.config.jca.DistributedWorkmanager;
import org.wildfly.swarm.config.jca.WorkmanagerConsumer;
import org.wildfly.swarm.config.jca.WorkmanagerSupplier;
import org.wildfly.swarm.config.jca.Workmanager;
import org.wildfly.swarm.config.jca.BootstrapContextConsumer;
import org.wildfly.swarm.config.jca.BootstrapContextSupplier;
import org.wildfly.swarm.config.jca.BootstrapContext;
import org.wildfly.swarm.config.jca.CachedConnectionManager;
import org.wildfly.swarm.config.jca.CachedConnectionManagerConsumer;
import org.wildfly.swarm.config.jca.CachedConnectionManagerSupplier;
import org.wildfly.swarm.config.jca.BeanValidation;
import org.wildfly.swarm.config.jca.BeanValidationConsumer;
import org.wildfly.swarm.config.jca.BeanValidationSupplier;
import org.wildfly.swarm.config.jca.Tracer;
import org.wildfly.swarm.config.jca.TracerConsumer;
import org.wildfly.swarm.config.jca.TracerSupplier;
import org.wildfly.swarm.config.jca.ArchiveValidation;
import org.wildfly.swarm.config.jca.ArchiveValidationConsumer;
import org.wildfly.swarm.config.jca.ArchiveValidationSupplier;
/**
 * The Java EE Connector Architecture (JCA) subsystem providing general
 * configuration for resource adapters
 */
@Address("/subsystem=jca")
@ResourceType("subsystem")
@Implicit
public class JCA<T extends JCA<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private JCAResources subresources = new JCAResources();

	public JCA() {
		this.key = "jca";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public JCAResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all DistributedWorkmanager objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of DistributedWorkmanager objects.
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanagers(List<DistributedWorkmanager> value) {
		this.subresources.distributedWorkmanagers = value;
		return (T) this;
	}

	/**
	 * Add the DistributedWorkmanager object to the list of subresources
	 * 
	 * @param value
	 *            The DistributedWorkmanager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(DistributedWorkmanager value) {
		this.subresources.distributedWorkmanagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a DistributedWorkmanager object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the DistributedWorkmanager resource
	 * @param config
	 *            The DistributedWorkmanagerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(String childKey,
			DistributedWorkmanagerConsumer consumer) {
		DistributedWorkmanager<?> child = new DistributedWorkmanager<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		distributedWorkmanager(child);
		return (T) this;
	}

	/**
	 * Create and configure a DistributedWorkmanager object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the DistributedWorkmanager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(String childKey) {
		distributedWorkmanager(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied DistributedWorkmanager object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T distributedWorkmanager(DistributedWorkmanagerSupplier supplier) {
		distributedWorkmanager(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Workmanager objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Workmanager objects.
	 */
	@SuppressWarnings("unchecked")
	public T workmanagers(List<Workmanager> value) {
		this.subresources.workmanagers = value;
		return (T) this;
	}

	/**
	 * Add the Workmanager object to the list of subresources
	 * 
	 * @param value
	 *            The Workmanager to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(Workmanager value) {
		this.subresources.workmanagers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Workmanager object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Workmanager resource
	 * @param config
	 *            The WorkmanagerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(String childKey, WorkmanagerConsumer consumer) {
		Workmanager<?> child = new Workmanager<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		workmanager(child);
		return (T) this;
	}

	/**
	 * Create and configure a Workmanager object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Workmanager resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(String childKey) {
		workmanager(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Workmanager object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T workmanager(WorkmanagerSupplier supplier) {
		workmanager(supplier.get());
		return (T) this;
	}

	/**
	 * Add all BootstrapContext objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of BootstrapContext objects.
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContexts(List<BootstrapContext> value) {
		this.subresources.bootstrapContexts = value;
		return (T) this;
	}

	/**
	 * Add the BootstrapContext object to the list of subresources
	 * 
	 * @param value
	 *            The BootstrapContext to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(BootstrapContext value) {
		this.subresources.bootstrapContexts.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a BootstrapContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the BootstrapContext resource
	 * @param config
	 *            The BootstrapContextConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(String childKey, BootstrapContextConsumer consumer) {
		BootstrapContext<?> child = new BootstrapContext<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		bootstrapContext(child);
		return (T) this;
	}

	/**
	 * Create and configure a BootstrapContext object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the BootstrapContext resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(String childKey) {
		bootstrapContext(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied BootstrapContext object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T bootstrapContext(BootstrapContextSupplier supplier) {
		bootstrapContext(supplier.get());
		return (T) this;
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T cachedConnectionManager(CachedConnectionManager value) {
		this.subresources.cachedConnectionManager = value;
		return (T) this;
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T cachedConnectionManager(CachedConnectionManagerConsumer consumer) {
		CachedConnectionManager<?> child = new CachedConnectionManager<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.cachedConnectionManager = child;
		return (T) this;
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T cachedConnectionManager() {
		CachedConnectionManager<?> child = new CachedConnectionManager<>();
		this.subresources.cachedConnectionManager = child;
		return (T) this;
	}

	/**
	 * Cached connection manager for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T cachedConnectionManager(CachedConnectionManagerSupplier supplier) {
		this.subresources.cachedConnectionManager = supplier.get();
		return (T) this;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T beanValidation(BeanValidation value) {
		this.subresources.beanValidation = value;
		return (T) this;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T beanValidation(BeanValidationConsumer consumer) {
		BeanValidation<?> child = new BeanValidation<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.beanValidation = child;
		return (T) this;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T beanValidation() {
		BeanValidation<?> child = new BeanValidation<>();
		this.subresources.beanValidation = child;
		return (T) this;
	}

	/**
	 * Bean validation (JSR-303) for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T beanValidation(BeanValidationSupplier supplier) {
		this.subresources.beanValidation = supplier.get();
		return (T) this;
	}

	/**
	 * Tracer for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T tracer(Tracer value) {
		this.subresources.tracer = value;
		return (T) this;
	}

	/**
	 * Tracer for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T tracer(TracerConsumer consumer) {
		Tracer<?> child = new Tracer<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.tracer = child;
		return (T) this;
	}

	/**
	 * Tracer for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T tracer() {
		Tracer<?> child = new Tracer<>();
		this.subresources.tracer = child;
		return (T) this;
	}

	/**
	 * Tracer for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T tracer(TracerSupplier supplier) {
		this.subresources.tracer = supplier.get();
		return (T) this;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T archiveValidation(ArchiveValidation value) {
		this.subresources.archiveValidation = value;
		return (T) this;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T archiveValidation(ArchiveValidationConsumer consumer) {
		ArchiveValidation<?> child = new ArchiveValidation<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.archiveValidation = child;
		return (T) this;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T archiveValidation() {
		ArchiveValidation<?> child = new ArchiveValidation<>();
		this.subresources.archiveValidation = child;
		return (T) this;
	}

	/**
	 * Archive validation for resource adapters
	 */
	@SuppressWarnings("unchecked")
	public T archiveValidation(ArchiveValidationSupplier supplier) {
		this.subresources.archiveValidation = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for JCA
	 */
	public static class JCAResources {
		/**
		 * DistributedWorkManager for resource adapters
		 */
		private List<DistributedWorkmanager> distributedWorkmanagers = new java.util.ArrayList<>();
		/**
		 * WorkManager for resource adapters
		 */
		private List<Workmanager> workmanagers = new java.util.ArrayList<>();
		/**
		 * Bootstrap context for resource adapters
		 */
		private List<BootstrapContext> bootstrapContexts = new java.util.ArrayList<>();
		private CachedConnectionManager cachedConnectionManager;
		private BeanValidation beanValidation;
		private Tracer tracer;
		private ArchiveValidation archiveValidation;

		/**
		 * Get the list of DistributedWorkmanager resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<DistributedWorkmanager> distributedWorkmanagers() {
			return this.distributedWorkmanagers;
		}

		/**
		 * Get the list of Workmanager resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Workmanager> workmanagers() {
			return this.workmanagers;
		}

		/**
		 * Get the list of BootstrapContext resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<BootstrapContext> bootstrapContexts() {
			return this.bootstrapContexts;
		}

		/**
		 * Cached connection manager for resource adapters
		 */
		@Subresource
		public CachedConnectionManager cachedConnectionManager() {
			return this.cachedConnectionManager;
		}

		/**
		 * Bean validation (JSR-303) for resource adapters
		 */
		@Subresource
		public BeanValidation beanValidation() {
			return this.beanValidation;
		}

		/**
		 * Tracer for resource adapters
		 */
		@Subresource
		public Tracer tracer() {
			return this.tracer;
		}

		/**
		 * Archive validation for resource adapters
		 */
		@Subresource
		public ArchiveValidation archiveValidation() {
			return this.archiveValidation;
		}
	}
}