/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=logging/async-handler=*", "/subsystem=logging/logging-profile=*/async-handler=*"})
@ResourceType(value="async-handler")
public class AsyncHandler<T extends AsyncHandler<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private Boolean enabled;
    private String filterSpec;
    private String level;
    private String overflowAction;
    private Integer queueLength;
    private List<String> subhandlers;

    public AsyncHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="filter-spec")
    public String filterSpec() {
        return this.filterSpec;
    }

    public T filterSpec(String value) {
        String oldValue = this.filterSpec;
        this.filterSpec = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("filterSpec", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="level")
    public String level() {
        return this.level;
    }

    public T level(String value) {
        String oldValue = this.level;
        this.level = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("level", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="overflow-action")
    public String overflowAction() {
        return this.overflowAction;
    }

    public T overflowAction(String value) {
        String oldValue = this.overflowAction;
        this.overflowAction = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("overflowAction", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="queue-length")
    public Integer queueLength() {
        return this.queueLength;
    }

    public T queueLength(Integer value) {
        Integer oldValue = this.queueLength;
        this.queueLength = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("queueLength", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="subhandlers")
    public List<String> subhandlers() {
        return this.subhandlers;
    }

    public T subhandlers(List<String> value) {
        List<String> oldValue = this.subhandlers;
        this.subhandlers = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("subhandlers", oldValue, value);
        }
        return (T)this;
    }

    public T subhandler(String value) {
        if (this.subhandlers == null) {
            this.subhandlers = new ArrayList<String>();
        }
        this.subhandlers.add(value);
        return (T)this;
    }

    public T subhandlers(String ... args) {
        this.subhandlers(Arrays.asList(args));
        return (T)this;
    }
}

