package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.BinaryTable;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface BinaryTableConsumer<T extends BinaryTable<T>> {

	/**
	 * Configure a pre-constructed instance of BinaryTable resource
	 * 
	 * @parameter Instance of BinaryTable to configure
	 * @return nothing
	 */
	void accept(T value);

	default BinaryTableConsumer<T> andThen(BinaryTableConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}