package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Defines a table used to store cache entries whose keys can be expressed as
 * strings.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=string-jdbc/table=string",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=mixed-jdbc/table=string",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=string-jdbc/table=string",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=mixed-jdbc/table=string",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=string-jdbc/table=string",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=mixed-jdbc/table=string",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=string-jdbc/table=string",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=mixed-jdbc/table=string"})
@ResourceType("table")
@Implicit
public class StringTable<T extends StringTable<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer batchSize;
	private Map dataColumn;
	private Integer fetchSize;
	private Map idColumn;
	private String prefix;
	private Map timestampColumn;

	public StringTable() {
		this.key = "string";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * For DB inserts, the batch size determines how many inserts are batched
	 * together.
	 */
	@ModelNodeBinding(detypedName = "batch-size")
	public Integer batchSize() {
		return this.batchSize;
	}

	/**
	 * For DB inserts, the batch size determines how many inserts are batched
	 * together.
	 */
	@SuppressWarnings("unchecked")
	public T batchSize(Integer value) {
		Object oldValue = this.batchSize;
		this.batchSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("batchSize", oldValue, value);
		return (T) this;
	}

	/**
	 * A database column to hold cache entry data.
	 */
	@ModelNodeBinding(detypedName = "data-column")
	public Map dataColumn() {
		return this.dataColumn;
	}

	/**
	 * A database column to hold cache entry data.
	 */
	@SuppressWarnings("unchecked")
	public T dataColumn(Map value) {
		Object oldValue = this.dataColumn;
		this.dataColumn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("dataColumn", oldValue, value);
		return (T) this;
	}

	/**
	 * A database column to hold cache entry data.
	 */
	public T dataColumn(String key, Object value) {
		if (this.dataColumn == null) {
			this.dataColumn = new java.util.HashMap<>();
		}
		this.dataColumn.put(key, value);
		return (T) this;
	}

	/**
	 * For DB queries, the fetch size will be used to set the fetch size on
	 * ResultSets.
	 */
	@ModelNodeBinding(detypedName = "fetch-size")
	public Integer fetchSize() {
		return this.fetchSize;
	}

	/**
	 * For DB queries, the fetch size will be used to set the fetch size on
	 * ResultSets.
	 */
	@SuppressWarnings("unchecked")
	public T fetchSize(Integer value) {
		Object oldValue = this.fetchSize;
		this.fetchSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("fetchSize", oldValue, value);
		return (T) this;
	}

	/**
	 * A database column to hold cache entry ids.
	 */
	@ModelNodeBinding(detypedName = "id-column")
	public Map idColumn() {
		return this.idColumn;
	}

	/**
	 * A database column to hold cache entry ids.
	 */
	@SuppressWarnings("unchecked")
	public T idColumn(Map value) {
		Object oldValue = this.idColumn;
		this.idColumn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idColumn", oldValue, value);
		return (T) this;
	}

	/**
	 * A database column to hold cache entry ids.
	 */
	public T idColumn(String key, Object value) {
		if (this.idColumn == null) {
			this.idColumn = new java.util.HashMap<>();
		}
		this.idColumn.put(key, value);
		return (T) this;
	}

	/**
	 * The prefix for the database table name.
	 */
	@ModelNodeBinding(detypedName = "prefix")
	public String prefix() {
		return this.prefix;
	}

	/**
	 * The prefix for the database table name.
	 */
	@SuppressWarnings("unchecked")
	public T prefix(String value) {
		Object oldValue = this.prefix;
		this.prefix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("prefix", oldValue, value);
		return (T) this;
	}

	/**
	 * A database column to hold cache entry timestamps.
	 */
	@ModelNodeBinding(detypedName = "timestamp-column")
	public Map timestampColumn() {
		return this.timestampColumn;
	}

	/**
	 * A database column to hold cache entry timestamps.
	 */
	@SuppressWarnings("unchecked")
	public T timestampColumn(Map value) {
		Object oldValue = this.timestampColumn;
		this.timestampColumn = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timestampColumn", oldValue, value);
		return (T) this;
	}

	/**
	 * A database column to hold cache entry timestamps.
	 */
	public T timestampColumn(String key, Object value) {
		if (this.timestampColumn == null) {
			this.timestampColumn = new java.util.HashMap<>();
		}
		this.timestampColumn.put(key, value);
		return (T) this;
	}
}