package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines a handler which writes to the console.
 */
@Addresses({"/subsystem=logging/logging-profile=*/console-handler=*",
		"/subsystem=logging/console-handler=*"})
@ResourceType("console-handler")
public class ConsoleHandler<T extends ConsoleHandler<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean autoflush;
	private Boolean enabled;
	private String encoding;
	private String filterSpec;
	private String formatter;
	private String level;
	private String namedFormatter;
	private String target;

	public ConsoleHandler(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Automatically flush after each write.
	 */
	@ModelNodeBinding(detypedName = "autoflush")
	public Boolean autoflush() {
		return this.autoflush;
	}

	/**
	 * Automatically flush after each write.
	 */
	@SuppressWarnings("unchecked")
	public T autoflush(Boolean value) {
		Object oldValue = this.autoflush;
		this.autoflush = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("autoflush", oldValue, value);
		return (T) this;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If set to true the handler is enabled and functioning as normal, if set
	 * to false the handler is ignored when processing log messages.
	 */
	@SuppressWarnings("unchecked")
	public T enabled(Boolean value) {
		Object oldValue = this.enabled;
		this.enabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The character encoding used by this Handler.
	 */
	@ModelNodeBinding(detypedName = "encoding")
	public String encoding() {
		return this.encoding;
	}

	/**
	 * The character encoding used by this Handler.
	 */
	@SuppressWarnings("unchecked")
	public T encoding(String value) {
		Object oldValue = this.encoding;
		this.encoding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("encoding", oldValue, value);
		return (T) this;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@ModelNodeBinding(detypedName = "filter-spec")
	public String filterSpec() {
		return this.filterSpec;
	}

	/**
	 * A filter expression value to define a filter. Example for a filter that
	 * does not match a pattern: not(match("JBAS.*"))
	 */
	@SuppressWarnings("unchecked")
	public T filterSpec(String value) {
		Object oldValue = this.filterSpec;
		this.filterSpec = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("filterSpec", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@ModelNodeBinding(detypedName = "formatter")
	public String formatter() {
		return this.formatter;
	}

	/**
	 * Defines a pattern for the formatter.
	 */
	@SuppressWarnings("unchecked")
	public T formatter(String value) {
		Object oldValue = this.formatter;
		this.formatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("formatter", oldValue, value);
		return (T) this;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@ModelNodeBinding(detypedName = "level")
	public String level() {
		return this.level;
	}

	/**
	 * The log level specifying which message levels will be logged by this
	 * logger. Message levels lower than this value will be discarded.
	 */
	@SuppressWarnings("unchecked")
	public T level(String value) {
		Object oldValue = this.level;
		this.level = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("level", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the defined formatter to be used on the handler.
	 */
	@ModelNodeBinding(detypedName = "named-formatter")
	public String namedFormatter() {
		return this.namedFormatter;
	}

	/**
	 * The name of the defined formatter to be used on the handler.
	 */
	@SuppressWarnings("unchecked")
	public T namedFormatter(String value) {
		Object oldValue = this.namedFormatter;
		this.namedFormatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("namedFormatter", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the target of the console handler. The value can be System.out,
	 * System.err or console.
	 */
	@ModelNodeBinding(detypedName = "target")
	public String target() {
		return this.target;
	}

	/**
	 * Defines the target of the console handler. The value can be System.out,
	 * System.err or console.
	 */
	@SuppressWarnings("unchecked")
	public T target(String value) {
		Object oldValue = this.target;
		this.target = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("target", oldValue, value);
		return (T) this;
	}
}