package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * A connector can be used by a client to define how it connects to a server.
 */
@Address("/subsystem=messaging-activemq/server=*/connector=*")
@ResourceType("connector")
public class Connector<T extends Connector<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String factoryClass;
	private Map params;
	private String socketBinding;

	public Connector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of the factory class that can instantiate the connector.
	 */
	@ModelNodeBinding(detypedName = "factory-class")
	public String factoryClass() {
		return this.factoryClass;
	}

	/**
	 * Class name of the factory class that can instantiate the connector.
	 */
	@SuppressWarnings("unchecked")
	public T factoryClass(String value) {
		Object oldValue = this.factoryClass;
		this.factoryClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("factoryClass", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		Object oldValue = this.params;
		this.params = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("params", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	public T param(String key, Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}
}