package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.HTTPAcceptor;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface HTTPAcceptorConsumer<T extends HTTPAcceptor<T>> {

	/**
	 * Configure a pre-constructed instance of HTTPAcceptor resource
	 * 
	 * @parameter Instance of HTTPAcceptor to configure
	 * @return nothing
	 */
	void accept(T value);

	default HTTPAcceptorConsumer<T> andThen(HTTPAcceptorConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}