package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Used by an in-VM client to define how it connects to a server.
 */
@Address("/subsystem=messaging-activemq/server=*/in-vm-connector=*")
@ResourceType("in-vm-connector")
public class InVMConnector<T extends InVMConnector<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Map params;
	private Integer serverId;

	public InVMConnector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	@SuppressWarnings("unchecked")
	public T params(Map value) {
		Object oldValue = this.params;
		this.params = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("params", oldValue, value);
		return (T) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to
	 * configure it.
	 */
	public T param(String key, Object value) {
		if (this.params == null) {
			this.params = new java.util.HashMap<>();
		}
		this.params.put(key, value);
		return (T) this;
	}

	/**
	 * The server id.
	 */
	@ModelNodeBinding(detypedName = "server-id")
	public Integer serverId() {
		return this.serverId;
	}

	/**
	 * The server id.
	 */
	@SuppressWarnings("unchecked")
	public T serverId(Integer value) {
		Object oldValue = this.serverId;
		this.serverId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverId", oldValue, value);
		return (T) this;
	}
}