package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.JMSTopic;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface JMSTopicConsumer<T extends JMSTopic<T>> {

	/**
	 * Configure a pre-constructed instance of JMSTopic resource
	 * 
	 * @parameter Instance of JMSTopic to configure
	 * @return nothing
	 */
	void accept(T value);

	default JMSTopicConsumer<T> andThen(JMSTopicConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}