package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.remoting.SASLSecurity;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SASLSecurityConsumer<T extends SASLSecurity<T>> {

	/**
	 * Configure a pre-constructed instance of SASLSecurity resource
	 * 
	 * @parameter Instance of SASLSecurity to configure
	 * @return nothing
	 */
	void accept(T value);

	default SASLSecurityConsumer<T> andThen(SASLSecurityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}