package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMappingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMappingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMapping;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSetting;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.JSPSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSettingSupplier;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSetting;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSettingConsumer;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSettingSupplier;
/**
 * A servlet container
 */
@Address("/subsystem=undertow/servlet-container=*")
@ResourceType("servlet-container")
public class ServletContainer<T extends ServletContainer<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Boolean allowNonStandardWrappers;
	private String defaultBufferCache;
	private String defaultEncoding;
	private Integer defaultSessionTimeout;
	private Boolean directoryListing;
	private Boolean disableCachingForSecuredPages;
	private Boolean eagerFilterInitialization;
	private Boolean ignoreFlush;
	private Integer maxSessions;
	private Boolean proactiveAuthentication;
	private Integer sessionIdLength;
	private String stackTraceOnError;
	private Boolean useListenerEncoding;
	private ServletContainerResources subresources = new ServletContainerResources();

	public ServletContainer(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * If true then request and response wrappers that do not extend the
	 * standard wrapper classes can be used
	 */
	@ModelNodeBinding(detypedName = "allow-non-standard-wrappers")
	public Boolean allowNonStandardWrappers() {
		return this.allowNonStandardWrappers;
	}

	/**
	 * If true then request and response wrappers that do not extend the
	 * standard wrapper classes can be used
	 */
	@SuppressWarnings("unchecked")
	public T allowNonStandardWrappers(Boolean value) {
		Object oldValue = this.allowNonStandardWrappers;
		this.allowNonStandardWrappers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowNonStandardWrappers", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The buffer cache to use for caching static resources
	 */
	@ModelNodeBinding(detypedName = "default-buffer-cache")
	public String defaultBufferCache() {
		return this.defaultBufferCache;
	}

	/**
	 * The buffer cache to use for caching static resources
	 */
	@SuppressWarnings("unchecked")
	public T defaultBufferCache(String value) {
		Object oldValue = this.defaultBufferCache;
		this.defaultBufferCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultBufferCache", oldValue, value);
		return (T) this;
	}

	/**
	 * Default encoding to use for all deployed applications
	 */
	@ModelNodeBinding(detypedName = "default-encoding")
	public String defaultEncoding() {
		return this.defaultEncoding;
	}

	/**
	 * Default encoding to use for all deployed applications
	 */
	@SuppressWarnings("unchecked")
	public T defaultEncoding(String value) {
		Object oldValue = this.defaultEncoding;
		this.defaultEncoding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultEncoding", oldValue, value);
		return (T) this;
	}

	/**
	 * The default session timeout (in minutes) for all applications deployed in
	 * the container.
	 */
	@ModelNodeBinding(detypedName = "default-session-timeout")
	public Integer defaultSessionTimeout() {
		return this.defaultSessionTimeout;
	}

	/**
	 * The default session timeout (in minutes) for all applications deployed in
	 * the container.
	 */
	@SuppressWarnings("unchecked")
	public T defaultSessionTimeout(Integer value) {
		Object oldValue = this.defaultSessionTimeout;
		this.defaultSessionTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultSessionTimeout", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If directory listing should be enabled for default servlets.
	 */
	@ModelNodeBinding(detypedName = "directory-listing")
	public Boolean directoryListing() {
		return this.directoryListing;
	}

	/**
	 * If directory listing should be enabled for default servlets.
	 */
	@SuppressWarnings("unchecked")
	public T directoryListing(Boolean value) {
		Object oldValue = this.directoryListing;
		this.directoryListing = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("directoryListing", oldValue, value);
		return (T) this;
	}

	/**
	 * If Undertow should set headers to disable caching for secured paged.
	 * Disabling this can cause security problems, as sensitive pages may be
	 * cached by an intermediary.
	 */
	@ModelNodeBinding(detypedName = "disable-caching-for-secured-pages")
	public Boolean disableCachingForSecuredPages() {
		return this.disableCachingForSecuredPages;
	}

	/**
	 * If Undertow should set headers to disable caching for secured paged.
	 * Disabling this can cause security problems, as sensitive pages may be
	 * cached by an intermediary.
	 */
	@SuppressWarnings("unchecked")
	public T disableCachingForSecuredPages(Boolean value) {
		Object oldValue = this.disableCachingForSecuredPages;
		this.disableCachingForSecuredPages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disableCachingForSecuredPages",
					oldValue, value);
		return (T) this;
	}

	/**
	 * If true undertow calls filter init() on deployment start rather than when
	 * first requested.
	 */
	@ModelNodeBinding(detypedName = "eager-filter-initialization")
	public Boolean eagerFilterInitialization() {
		return this.eagerFilterInitialization;
	}

	/**
	 * If true undertow calls filter init() on deployment start rather than when
	 * first requested.
	 */
	@SuppressWarnings("unchecked")
	public T eagerFilterInitialization(Boolean value) {
		Object oldValue = this.eagerFilterInitialization;
		this.eagerFilterInitialization = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("eagerFilterInitialization", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Ignore flushes on the servlet output stream. In most cases these just
	 * hurt performance for no good reason.
	 */
	@ModelNodeBinding(detypedName = "ignore-flush")
	public Boolean ignoreFlush() {
		return this.ignoreFlush;
	}

	/**
	 * Ignore flushes on the servlet output stream. In most cases these just
	 * hurt performance for no good reason.
	 */
	@SuppressWarnings("unchecked")
	public T ignoreFlush(Boolean value) {
		Object oldValue = this.ignoreFlush;
		this.ignoreFlush = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("ignoreFlush", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of sessions that can be active at one time
	 */
	@ModelNodeBinding(detypedName = "max-sessions")
	public Integer maxSessions() {
		return this.maxSessions;
	}

	/**
	 * The maximum number of sessions that can be active at one time
	 */
	@SuppressWarnings("unchecked")
	public T maxSessions(Integer value) {
		Object oldValue = this.maxSessions;
		this.maxSessions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxSessions", oldValue, value);
		return (T) this;
	}

	/**
	 * If proactive authentication should be used. If this is true a user will
	 * always be authenticated if credentials are present.
	 */
	@ModelNodeBinding(detypedName = "proactive-authentication")
	public Boolean proactiveAuthentication() {
		return this.proactiveAuthentication;
	}

	/**
	 * If proactive authentication should be used. If this is true a user will
	 * always be authenticated if credentials are present.
	 */
	@SuppressWarnings("unchecked")
	public T proactiveAuthentication(Boolean value) {
		Object oldValue = this.proactiveAuthentication;
		this.proactiveAuthentication = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("proactiveAuthentication", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The length of the generated session ID. Longer session ID's are more
	 * secure.
	 */
	@ModelNodeBinding(detypedName = "session-id-length")
	public Integer sessionIdLength() {
		return this.sessionIdLength;
	}

	/**
	 * The length of the generated session ID. Longer session ID's are more
	 * secure.
	 */
	@SuppressWarnings("unchecked")
	public T sessionIdLength(Integer value) {
		Object oldValue = this.sessionIdLength;
		this.sessionIdLength = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sessionIdLength", oldValue, value);
		return (T) this;
	}

	/**
	 * If an error page with the stack trace should be generated on error.
	 * Values are all, none and local-only
	 */
	@ModelNodeBinding(detypedName = "stack-trace-on-error")
	public String stackTraceOnError() {
		return this.stackTraceOnError;
	}

	/**
	 * If an error page with the stack trace should be generated on error.
	 * Values are all, none and local-only
	 */
	@SuppressWarnings("unchecked")
	public T stackTraceOnError(String value) {
		Object oldValue = this.stackTraceOnError;
		this.stackTraceOnError = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stackTraceOnError", oldValue, value);
		return (T) this;
	}

	/**
	 * Use encoding defined on listener
	 */
	@ModelNodeBinding(detypedName = "use-listener-encoding")
	public Boolean useListenerEncoding() {
		return this.useListenerEncoding;
	}

	/**
	 * Use encoding defined on listener
	 */
	@SuppressWarnings("unchecked")
	public T useListenerEncoding(Boolean value) {
		Object oldValue = this.useListenerEncoding;
		this.useListenerEncoding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useListenerEncoding", oldValue, value);
		return (T) this;
	}

	public ServletContainerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all MimeMapping objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of MimeMapping objects.
	 */
	@SuppressWarnings("unchecked")
	public T mimeMappings(List<MimeMapping> value) {
		this.subresources.mimeMappings = value;
		return (T) this;
	}

	/**
	 * Add the MimeMapping object to the list of subresources
	 * 
	 * @param value
	 *            The MimeMapping to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(MimeMapping value) {
		this.subresources.mimeMappings.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a MimeMapping object to the list of subresources
	 * 
	 * @param key
	 *            The key for the MimeMapping resource
	 * @param config
	 *            The MimeMappingConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(String childKey, MimeMappingConsumer consumer) {
		MimeMapping<?> child = new MimeMapping<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		mimeMapping(child);
		return (T) this;
	}

	/**
	 * Create and configure a MimeMapping object to the list of subresources
	 * 
	 * @param key
	 *            The key for the MimeMapping resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(String childKey) {
		mimeMapping(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied MimeMapping object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T mimeMapping(MimeMappingSupplier supplier) {
		mimeMapping(supplier.get());
		return (T) this;
	}

	/**
	 * Add all WelcomeFile objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of WelcomeFile objects.
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFiles(List<WelcomeFile> value) {
		this.subresources.welcomeFiles = value;
		return (T) this;
	}

	/**
	 * Add the WelcomeFile object to the list of subresources
	 * 
	 * @param value
	 *            The WelcomeFile to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(WelcomeFile value) {
		this.subresources.welcomeFiles.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a WelcomeFile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the WelcomeFile resource
	 * @param config
	 *            The WelcomeFileConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(String childKey, WelcomeFileConsumer consumer) {
		WelcomeFile<?> child = new WelcomeFile<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		welcomeFile(child);
		return (T) this;
	}

	/**
	 * Create and configure a WelcomeFile object to the list of subresources
	 * 
	 * @param key
	 *            The key for the WelcomeFile resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(String childKey) {
		welcomeFile(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied WelcomeFile object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T welcomeFile(WelcomeFileSupplier supplier) {
		welcomeFile(supplier.get());
		return (T) this;
	}

	/**
	 * Session persistence sessions
	 */
	@SuppressWarnings("unchecked")
	public T persistentSessionsSetting(PersistentSessionsSetting value) {
		this.subresources.persistentSessionsSetting = value;
		return (T) this;
	}

	/**
	 * Session persistence sessions
	 */
	@SuppressWarnings("unchecked")
	public T persistentSessionsSetting(
			PersistentSessionsSettingConsumer consumer) {
		PersistentSessionsSetting<?> child = new PersistentSessionsSetting<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.persistentSessionsSetting = child;
		return (T) this;
	}

	/**
	 * Session persistence sessions
	 */
	@SuppressWarnings("unchecked")
	public T persistentSessionsSetting() {
		PersistentSessionsSetting<?> child = new PersistentSessionsSetting<>();
		this.subresources.persistentSessionsSetting = child;
		return (T) this;
	}

	/**
	 * Session persistence sessions
	 */
	@SuppressWarnings("unchecked")
	public T persistentSessionsSetting(
			PersistentSessionsSettingSupplier supplier) {
		this.subresources.persistentSessionsSetting = supplier.get();
		return (T) this;
	}

	/**
	 * JSP container configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jspSetting(JSPSetting value) {
		this.subresources.jspSetting = value;
		return (T) this;
	}

	/**
	 * JSP container configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jspSetting(JSPSettingConsumer consumer) {
		JSPSetting<?> child = new JSPSetting<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.jspSetting = child;
		return (T) this;
	}

	/**
	 * JSP container configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jspSetting() {
		JSPSetting<?> child = new JSPSetting<>();
		this.subresources.jspSetting = child;
		return (T) this;
	}

	/**
	 * JSP container configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jspSetting(JSPSettingSupplier supplier) {
		this.subresources.jspSetting = supplier.get();
		return (T) this;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@SuppressWarnings("unchecked")
	public T websocketsSetting(WebsocketsSetting value) {
		this.subresources.websocketsSetting = value;
		return (T) this;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@SuppressWarnings("unchecked")
	public T websocketsSetting(WebsocketsSettingConsumer consumer) {
		WebsocketsSetting<?> child = new WebsocketsSetting<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.websocketsSetting = child;
		return (T) this;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@SuppressWarnings("unchecked")
	public T websocketsSetting() {
		WebsocketsSetting<?> child = new WebsocketsSetting<>();
		this.subresources.websocketsSetting = child;
		return (T) this;
	}

	/**
	 * If websockets are enabled for this container
	 */
	@SuppressWarnings("unchecked")
	public T websocketsSetting(WebsocketsSettingSupplier supplier) {
		this.subresources.websocketsSetting = supplier.get();
		return (T) this;
	}

	/**
	 * Session cookie configuration
	 */
	@SuppressWarnings("unchecked")
	public T sessionCookieSetting(SessionCookieSetting value) {
		this.subresources.sessionCookieSetting = value;
		return (T) this;
	}

	/**
	 * Session cookie configuration
	 */
	@SuppressWarnings("unchecked")
	public T sessionCookieSetting(SessionCookieSettingConsumer consumer) {
		SessionCookieSetting<?> child = new SessionCookieSetting<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.sessionCookieSetting = child;
		return (T) this;
	}

	/**
	 * Session cookie configuration
	 */
	@SuppressWarnings("unchecked")
	public T sessionCookieSetting() {
		SessionCookieSetting<?> child = new SessionCookieSetting<>();
		this.subresources.sessionCookieSetting = child;
		return (T) this;
	}

	/**
	 * Session cookie configuration
	 */
	@SuppressWarnings("unchecked")
	public T sessionCookieSetting(SessionCookieSettingSupplier supplier) {
		this.subresources.sessionCookieSetting = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for ServletContainer
	 */
	public static class ServletContainerResources {
		/**
		 * The servlet container mime mapping config
		 */
		private List<MimeMapping> mimeMappings = new java.util.ArrayList<>();
		/**
		 * The welcome file
		 */
		private List<WelcomeFile> welcomeFiles = new java.util.ArrayList<>();
		private PersistentSessionsSetting persistentSessionsSetting;
		private JSPSetting jspSetting;
		private WebsocketsSetting websocketsSetting;
		private SessionCookieSetting sessionCookieSetting;

		/**
		 * Get the list of MimeMapping resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<MimeMapping> mimeMappings() {
			return this.mimeMappings;
		}

		/**
		 * Get the list of WelcomeFile resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<WelcomeFile> welcomeFiles() {
			return this.welcomeFiles;
		}

		/**
		 * Session persistence sessions
		 */
		@Subresource
		public PersistentSessionsSetting persistentSessionsSetting() {
			return this.persistentSessionsSetting;
		}

		/**
		 * JSP container configuration.
		 */
		@Subresource
		public JSPSetting jspSetting() {
			return this.jspSetting;
		}

		/**
		 * If websockets are enabled for this container
		 */
		@Subresource
		public WebsocketsSetting websocketsSetting() {
			return this.websocketsSetting;
		}

		/**
		 * Session cookie configuration
		 */
		@Subresource
		public SessionCookieSetting sessionCookieSetting() {
			return this.sessionCookieSetting;
		}
	}
}