/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStore;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStoreConsumer;
import org.wildfly.swarm.config.ejb3.service.DatabaseDataStoreSupplier;
import org.wildfly.swarm.config.ejb3.service.FileDataStore;
import org.wildfly.swarm.config.ejb3.service.FileDataStoreConsumer;
import org.wildfly.swarm.config.ejb3.service.FileDataStoreSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=ejb3/service=timer-service")
@ResourceType(value="service")
@Implicit
public class TimerService<T extends TimerService<T>> {
    private String key = "timer-service";
    private PropertyChangeSupport pcs;
    private String defaultDataStore;
    private String threadPoolName;
    private TimerServiceResources subresources = new TimerServiceResources();

    public TimerService() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="default-data-store")
    public String defaultDataStore() {
        return this.defaultDataStore;
    }

    public T defaultDataStore(String value) {
        String oldValue = this.defaultDataStore;
        this.defaultDataStore = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("defaultDataStore", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="thread-pool-name")
    public String threadPoolName() {
        return this.threadPoolName;
    }

    public T threadPoolName(String value) {
        String oldValue = this.threadPoolName;
        this.threadPoolName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("threadPoolName", oldValue, value);
        }
        return (T)this;
    }

    public TimerServiceResources subresources() {
        return this.subresources;
    }

    public T fileDataStores(List<FileDataStore> value) {
        this.subresources.fileDataStores = value;
        return (T)this;
    }

    public T fileDataStore(FileDataStore value) {
        this.subresources.fileDataStores.add(value);
        return (T)this;
    }

    public T fileDataStore(String childKey, FileDataStoreConsumer consumer) {
        FileDataStore child = new FileDataStore(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.fileDataStore(child);
        return (T)this;
    }

    public T fileDataStore(String childKey) {
        this.fileDataStore(childKey, null);
        return (T)this;
    }

    public T fileDataStore(FileDataStoreSupplier supplier) {
        this.fileDataStore(supplier.get());
        return (T)this;
    }

    public T databaseDataStores(List<DatabaseDataStore> value) {
        this.subresources.databaseDataStores = value;
        return (T)this;
    }

    public T databaseDataStore(DatabaseDataStore value) {
        this.subresources.databaseDataStores.add(value);
        return (T)this;
    }

    public T databaseDataStore(String childKey, DatabaseDataStoreConsumer consumer) {
        DatabaseDataStore child = new DatabaseDataStore(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.databaseDataStore(child);
        return (T)this;
    }

    public T databaseDataStore(String childKey) {
        this.databaseDataStore(childKey, null);
        return (T)this;
    }

    public T databaseDataStore(DatabaseDataStoreSupplier supplier) {
        this.databaseDataStore(supplier.get());
        return (T)this;
    }

    public static class TimerServiceResources {
        private List<FileDataStore> fileDataStores = new ArrayList<FileDataStore>();
        private List<DatabaseDataStore> databaseDataStores = new ArrayList<DatabaseDataStore>();

        @Subresource
        public List<FileDataStore> fileDataStores() {
            return this.fileDataStores;
        }

        @Subresource
        public List<DatabaseDataStore> databaseDataStores() {
            return this.databaseDataStores;
        }
    }
}

