/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.jgroups.stack;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.jgroups.Property;
import org.wildfly.swarm.config.jgroups.PropertyConsumer;
import org.wildfly.swarm.config.jgroups.PropertySupplier;
import org.wildfly.swarm.config.jgroups.stack.transport.DefaultThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.DefaultThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.DefaultThreadPoolSupplier;
import org.wildfly.swarm.config.jgroups.stack.transport.InternalThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.InternalThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.InternalThreadPoolSupplier;
import org.wildfly.swarm.config.jgroups.stack.transport.OobThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.OobThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.OobThreadPoolSupplier;
import org.wildfly.swarm.config.jgroups.stack.transport.TimerThreadPool;
import org.wildfly.swarm.config.jgroups.stack.transport.TimerThreadPoolConsumer;
import org.wildfly.swarm.config.jgroups.stack.transport.TimerThreadPoolSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=jgroups/stack=*/transport=*")
@ResourceType(value="transport")
public class Transport<T extends Transport<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private String diagnosticsSocketBinding;
    private String machine;
    private String module;
    private Map properties;
    private String rack;
    private Boolean shared;
    private String site;
    private String socketBinding;
    private TransportResources subresources = new TransportResources();

    public Transport(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="diagnostics-socket-binding")
    public String diagnosticsSocketBinding() {
        return this.diagnosticsSocketBinding;
    }

    public T diagnosticsSocketBinding(String value) {
        String oldValue = this.diagnosticsSocketBinding;
        this.diagnosticsSocketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("diagnosticsSocketBinding", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="machine")
    public String machine() {
        return this.machine;
    }

    public T machine(String value) {
        String oldValue = this.machine;
        this.machine = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("machine", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="properties")
    public Map properties() {
        return this.properties;
    }

    public T properties(Map value) {
        Map oldValue = this.properties;
        this.properties = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("properties", oldValue, value);
        }
        return (T)this;
    }

    public T property(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="rack")
    public String rack() {
        return this.rack;
    }

    public T rack(String value) {
        String oldValue = this.rack;
        this.rack = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("rack", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="shared")
    public Boolean shared() {
        return this.shared;
    }

    public T shared(Boolean value) {
        Boolean oldValue = this.shared;
        this.shared = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("shared", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="site")
    public String site() {
        return this.site;
    }

    public T site(String value) {
        String oldValue = this.site;
        this.site = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("site", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="socket-binding")
    public String socketBinding() {
        return this.socketBinding;
    }

    public T socketBinding(String value) {
        String oldValue = this.socketBinding;
        this.socketBinding = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("socketBinding", oldValue, value);
        }
        return (T)this;
    }

    public TransportResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public T oobThreadPool(OobThreadPool value) {
        this.subresources.oobThreadPool = value;
        return (T)this;
    }

    public T oobThreadPool(OobThreadPoolConsumer consumer) {
        OobThreadPool child = new OobThreadPool();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.oobThreadPool = child;
        return (T)this;
    }

    public T oobThreadPool() {
        OobThreadPool child = new OobThreadPool();
        this.subresources.oobThreadPool = child;
        return (T)this;
    }

    public T oobThreadPool(OobThreadPoolSupplier supplier) {
        this.subresources.oobThreadPool = supplier.get();
        return (T)this;
    }

    public T internalThreadPool(InternalThreadPool value) {
        this.subresources.internalThreadPool = value;
        return (T)this;
    }

    public T internalThreadPool(InternalThreadPoolConsumer consumer) {
        InternalThreadPool child = new InternalThreadPool();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.internalThreadPool = child;
        return (T)this;
    }

    public T internalThreadPool() {
        InternalThreadPool child = new InternalThreadPool();
        this.subresources.internalThreadPool = child;
        return (T)this;
    }

    public T internalThreadPool(InternalThreadPoolSupplier supplier) {
        this.subresources.internalThreadPool = supplier.get();
        return (T)this;
    }

    public T defaultThreadPool(DefaultThreadPool value) {
        this.subresources.defaultThreadPool = value;
        return (T)this;
    }

    public T defaultThreadPool(DefaultThreadPoolConsumer consumer) {
        DefaultThreadPool child = new DefaultThreadPool();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.defaultThreadPool = child;
        return (T)this;
    }

    public T defaultThreadPool() {
        DefaultThreadPool child = new DefaultThreadPool();
        this.subresources.defaultThreadPool = child;
        return (T)this;
    }

    public T defaultThreadPool(DefaultThreadPoolSupplier supplier) {
        this.subresources.defaultThreadPool = supplier.get();
        return (T)this;
    }

    public T timerThreadPool(TimerThreadPool value) {
        this.subresources.timerThreadPool = value;
        return (T)this;
    }

    public T timerThreadPool(TimerThreadPoolConsumer consumer) {
        TimerThreadPool child = new TimerThreadPool();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.timerThreadPool = child;
        return (T)this;
    }

    public T timerThreadPool() {
        TimerThreadPool child = new TimerThreadPool();
        this.subresources.timerThreadPool = child;
        return (T)this;
    }

    public T timerThreadPool(TimerThreadPoolSupplier supplier) {
        this.subresources.timerThreadPool = supplier.get();
        return (T)this;
    }

    public static class TransportResources {
        private List<Property> properties = new ArrayList<Property>();
        private OobThreadPool oobThreadPool;
        private InternalThreadPool internalThreadPool;
        private DefaultThreadPool defaultThreadPool;
        private TimerThreadPool timerThreadPool;

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        @Subresource
        public OobThreadPool oobThreadPool() {
            return this.oobThreadPool;
        }

        @Subresource
        public InternalThreadPool internalThreadPool() {
            return this.internalThreadPool;
        }

        @Subresource
        public DefaultThreadPool defaultThreadPool() {
            return this.defaultThreadPool;
        }

        @Subresource
        public TimerThreadPool timerThreadPool() {
            return this.timerThreadPool;
        }
    }
}

