/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security.security_domain.authentication;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleSupplier;

@Address(value="/subsystem=security/security-domain=*/authentication=jaspi/login-module-stack=*")
@ResourceType(value="login-module-stack")
public class LoginModuleStack<T extends LoginModuleStack<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private LoginModuleStackResources subresources = new LoginModuleStackResources();

    public LoginModuleStack(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public LoginModuleStackResources subresources() {
        return this.subresources;
    }

    public T loginModules(List<LoginModule> value) {
        this.subresources.loginModules = value;
        return (T)this;
    }

    public T loginModule(LoginModule value) {
        this.subresources.loginModules.add(value);
        return (T)this;
    }

    public T loginModule(String childKey, LoginModuleConsumer consumer) {
        LoginModule child = new LoginModule(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.loginModule(child);
        return (T)this;
    }

    public T loginModule(String childKey) {
        this.loginModule(childKey, null);
        return (T)this;
    }

    public T loginModule(LoginModuleSupplier supplier) {
        this.loginModule(supplier.get());
        return (T)this;
    }

    public static class LoginModuleStackResources {
        private List<LoginModule> loginModules = new ArrayList<LoginModule>();

        @Subresource
        public List<LoginModule> loginModules() {
            return this.loginModules;
        }
    }
}

