/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.ConnectionLimit;
import org.wildfly.swarm.config.undertow.configuration.ConnectionLimitConsumer;
import org.wildfly.swarm.config.undertow.configuration.ConnectionLimitSupplier;
import org.wildfly.swarm.config.undertow.configuration.CustomFilter;
import org.wildfly.swarm.config.undertow.configuration.CustomFilterConsumer;
import org.wildfly.swarm.config.undertow.configuration.CustomFilterSupplier;
import org.wildfly.swarm.config.undertow.configuration.ErrorPage;
import org.wildfly.swarm.config.undertow.configuration.ErrorPageConsumer;
import org.wildfly.swarm.config.undertow.configuration.ErrorPageSupplier;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilter;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilterConsumer;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilterSupplier;
import org.wildfly.swarm.config.undertow.configuration.Gzip;
import org.wildfly.swarm.config.undertow.configuration.GzipConsumer;
import org.wildfly.swarm.config.undertow.configuration.GzipSupplier;
import org.wildfly.swarm.config.undertow.configuration.ModCluster;
import org.wildfly.swarm.config.undertow.configuration.ModClusterConsumer;
import org.wildfly.swarm.config.undertow.configuration.ModClusterSupplier;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeader;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeaderConsumer;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeaderSupplier;
import org.wildfly.swarm.config.undertow.configuration.Rewrite;
import org.wildfly.swarm.config.undertow.configuration.RewriteConsumer;
import org.wildfly.swarm.config.undertow.configuration.RewriteSupplier;

@Address(value="/subsystem=undertow/configuration=filter")
@ResourceType(value="configuration")
@Implicit
public class FilterConfiguration<T extends FilterConfiguration<T>> {
    private String key = "filter";
    private PropertyChangeSupport pcs;
    private FilterConfigurationResources subresources = new FilterConfigurationResources();

    public FilterConfiguration() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public FilterConfigurationResources subresources() {
        return this.subresources;
    }

    public T errorPages(List<ErrorPage> value) {
        this.subresources.errorPages = value;
        return (T)this;
    }

    public T errorPage(ErrorPage value) {
        this.subresources.errorPages.add(value);
        return (T)this;
    }

    public T errorPage(String childKey, ErrorPageConsumer consumer) {
        ErrorPage child = new ErrorPage(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.errorPage(child);
        return (T)this;
    }

    public T errorPage(String childKey) {
        this.errorPage(childKey, null);
        return (T)this;
    }

    public T errorPage(ErrorPageSupplier supplier) {
        this.errorPage(supplier.get());
        return (T)this;
    }

    public T customFilters(List<CustomFilter> value) {
        this.subresources.customFilters = value;
        return (T)this;
    }

    public T customFilter(CustomFilter value) {
        this.subresources.customFilters.add(value);
        return (T)this;
    }

    public T customFilter(String childKey, CustomFilterConsumer consumer) {
        CustomFilter child = new CustomFilter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.customFilter(child);
        return (T)this;
    }

    public T customFilter(String childKey) {
        this.customFilter(childKey, null);
        return (T)this;
    }

    public T customFilter(CustomFilterSupplier supplier) {
        this.customFilter(supplier.get());
        return (T)this;
    }

    public T gzips(List<Gzip> value) {
        this.subresources.gzips = value;
        return (T)this;
    }

    public T gzip(Gzip value) {
        this.subresources.gzips.add(value);
        return (T)this;
    }

    public T gzip(String childKey, GzipConsumer consumer) {
        Gzip child = new Gzip(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.gzip(child);
        return (T)this;
    }

    public T gzip(String childKey) {
        this.gzip(childKey, null);
        return (T)this;
    }

    public T gzip(GzipSupplier supplier) {
        this.gzip(supplier.get());
        return (T)this;
    }

    public T modClusters(List<ModCluster> value) {
        this.subresources.modClusters = value;
        return (T)this;
    }

    public T modCluster(ModCluster value) {
        this.subresources.modClusters.add(value);
        return (T)this;
    }

    public T modCluster(String childKey, ModClusterConsumer consumer) {
        ModCluster child = new ModCluster(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.modCluster(child);
        return (T)this;
    }

    public T modCluster(String childKey) {
        this.modCluster(childKey, null);
        return (T)this;
    }

    public T modCluster(ModClusterSupplier supplier) {
        this.modCluster(supplier.get());
        return (T)this;
    }

    public T expressionFilters(List<ExpressionFilter> value) {
        this.subresources.expressionFilters = value;
        return (T)this;
    }

    public T expressionFilter(ExpressionFilter value) {
        this.subresources.expressionFilters.add(value);
        return (T)this;
    }

    public T expressionFilter(String childKey, ExpressionFilterConsumer consumer) {
        ExpressionFilter child = new ExpressionFilter(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.expressionFilter(child);
        return (T)this;
    }

    public T expressionFilter(String childKey) {
        this.expressionFilter(childKey, null);
        return (T)this;
    }

    public T expressionFilter(ExpressionFilterSupplier supplier) {
        this.expressionFilter(supplier.get());
        return (T)this;
    }

    public T responseHeaders(List<ResponseHeader> value) {
        this.subresources.responseHeaders = value;
        return (T)this;
    }

    public T responseHeader(ResponseHeader value) {
        this.subresources.responseHeaders.add(value);
        return (T)this;
    }

    public T responseHeader(String childKey, ResponseHeaderConsumer consumer) {
        ResponseHeader child = new ResponseHeader(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.responseHeader(child);
        return (T)this;
    }

    public T responseHeader(String childKey) {
        this.responseHeader(childKey, null);
        return (T)this;
    }

    public T responseHeader(ResponseHeaderSupplier supplier) {
        this.responseHeader(supplier.get());
        return (T)this;
    }

    public T rewrites(List<Rewrite> value) {
        this.subresources.rewrites = value;
        return (T)this;
    }

    public T rewrite(Rewrite value) {
        this.subresources.rewrites.add(value);
        return (T)this;
    }

    public T rewrite(String childKey, RewriteConsumer consumer) {
        Rewrite child = new Rewrite(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.rewrite(child);
        return (T)this;
    }

    public T rewrite(String childKey) {
        this.rewrite(childKey, null);
        return (T)this;
    }

    public T rewrite(RewriteSupplier supplier) {
        this.rewrite(supplier.get());
        return (T)this;
    }

    public T connectionLimits(List<ConnectionLimit> value) {
        this.subresources.connectionLimits = value;
        return (T)this;
    }

    public T connectionLimit(ConnectionLimit value) {
        this.subresources.connectionLimits.add(value);
        return (T)this;
    }

    public T connectionLimit(String childKey, ConnectionLimitConsumer consumer) {
        ConnectionLimit child = new ConnectionLimit(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.connectionLimit(child);
        return (T)this;
    }

    public T connectionLimit(String childKey) {
        this.connectionLimit(childKey, null);
        return (T)this;
    }

    public T connectionLimit(ConnectionLimitSupplier supplier) {
        this.connectionLimit(supplier.get());
        return (T)this;
    }

    public static class FilterConfigurationResources {
        private List<ErrorPage> errorPages = new ArrayList<ErrorPage>();
        private List<CustomFilter> customFilters = new ArrayList<CustomFilter>();
        private List<Gzip> gzips = new ArrayList<Gzip>();
        private List<ModCluster> modClusters = new ArrayList<ModCluster>();
        private List<ExpressionFilter> expressionFilters = new ArrayList<ExpressionFilter>();
        private List<ResponseHeader> responseHeaders = new ArrayList<ResponseHeader>();
        private List<Rewrite> rewrites = new ArrayList<Rewrite>();
        private List<ConnectionLimit> connectionLimits = new ArrayList<ConnectionLimit>();

        @Subresource
        public List<ErrorPage> errorPages() {
            return this.errorPages;
        }

        @Subresource
        public List<CustomFilter> customFilters() {
            return this.customFilters;
        }

        @Subresource
        public List<Gzip> gzips() {
            return this.gzips;
        }

        @Subresource
        public List<ModCluster> modClusters() {
            return this.modClusters;
        }

        @Subresource
        public List<ExpressionFilter> expressionFilters() {
            return this.expressionFilters;
        }

        @Subresource
        public List<ResponseHeader> responseHeaders() {
            return this.responseHeaders;
        }

        @Subresource
        public List<Rewrite> rewrites() {
            return this.rewrites;
        }

        @Subresource
        public List<ConnectionLimit> connectionLimits() {
            return this.connectionLimits;
        }
    }
}

