package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Logging;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface LoggingConsumer<T extends Logging<T>> {

	/**
	 * Configure a pre-constructed instance of Logging resource
	 * 
	 * @parameter Instance of Logging to configure
	 * @return nothing
	 */
	void accept(T value);

	default LoggingConsumer<T> andThen(LoggingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}