package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Webservices;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface WebservicesConsumer<T extends Webservices<T>> {

	/**
	 * Configure a pre-constructed instance of Webservices resource
	 * 
	 * @parameter Instance of Webservices to configure
	 * @return nothing
	 */
	void accept(T value);

	default WebservicesConsumer<T> andThen(WebservicesConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}