package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.BroadcastGroup;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface BroadcastGroupConsumer<T extends BroadcastGroup<T>> {

	/**
	 * Configure a pre-constructed instance of BroadcastGroup resource
	 * 
	 * @parameter Instance of BroadcastGroup to configure
	 * @return nothing
	 */
	void accept(T value);

	default BroadcastGroupConsumer<T> andThen(BroadcastGroupConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}