package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.ConnectorService;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ConnectorServiceConsumer<T extends ConnectorService<T>> {

	/**
	 * Configure a pre-constructed instance of ConnectorService resource
	 * 
	 * @parameter Instance of ConnectorService to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConnectorServiceConsumer<T> andThen(
			ConnectorServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}