package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.messaging_activemq.server.DiscoveryGroup;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface DiscoveryGroupConsumer<T extends DiscoveryGroup<T>> {

	/**
	 * Configure a pre-constructed instance of DiscoveryGroup resource
	 * 
	 * @parameter Instance of DiscoveryGroup to configure
	 * @return nothing
	 */
	void accept(T value);

	default DiscoveryGroupConsumer<T> andThen(DiscoveryGroupConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}