package org.wildfly.swarm.config.messaging_activemq.server.ha_policy.shared_store_colocated;

import org.wildfly.swarm.config.messaging_activemq.server.ha_policy.shared_store_colocated.SlaveConfiguration;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SlaveConfigurationConsumer<T extends SlaveConfiguration<T>> {

	/**
	 * Configure a pre-constructed instance of SlaveConfiguration resource
	 * 
	 * @parameter Instance of SlaveConfiguration to configure
	 * @return nothing
	 */
	void accept(T value);

	default SlaveConfigurationConsumer<T> andThen(
			SlaveConfigurationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}