package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStackConsumer;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStackSupplier;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModuleConsumer;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModuleSupplier;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModule;
/**
 * JASPI authentication configuration.
 */
@Address("/subsystem=security/security-domain=*/authentication=jaspi")
@ResourceType("authentication")
@Implicit
public class JaspiAuthentication<T extends JaspiAuthentication<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private JaspiAuthenticationResources subresources = new JaspiAuthenticationResources();

	public JaspiAuthentication() {
		this.key = "jaspi";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public JaspiAuthenticationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all LoginModuleStack objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LoginModuleStack objects.
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStacks(List<LoginModuleStack> value) {
		this.subresources.loginModuleStacks = value;
		return (T) this;
	}

	/**
	 * Add the LoginModuleStack object to the list of subresources
	 * 
	 * @param value
	 *            The LoginModuleStack to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStack(LoginModuleStack value) {
		this.subresources.loginModuleStacks.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LoginModuleStack object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LoginModuleStack resource
	 * @param config
	 *            The LoginModuleStackConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStack(String childKey, LoginModuleStackConsumer consumer) {
		LoginModuleStack<? extends LoginModuleStack> child = new LoginModuleStack<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		loginModuleStack(child);
		return (T) this;
	}

	/**
	 * Create and configure a LoginModuleStack object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the LoginModuleStack resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStack(String childKey) {
		loginModuleStack(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LoginModuleStack object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStack(LoginModuleStackSupplier supplier) {
		loginModuleStack(supplier.get());
		return (T) this;
	}

	/**
	 * Add all AuthModule objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of AuthModule objects.
	 */
	@SuppressWarnings("unchecked")
	public T authModules(List<AuthModule> value) {
		this.subresources.authModules = value;
		return (T) this;
	}

	/**
	 * Add the AuthModule object to the list of subresources
	 * 
	 * @param value
	 *            The AuthModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authModule(AuthModule value) {
		this.subresources.authModules.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a AuthModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AuthModule resource
	 * @param config
	 *            The AuthModuleConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authModule(String childKey, AuthModuleConsumer consumer) {
		AuthModule<? extends AuthModule> child = new AuthModule<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		authModule(child);
		return (T) this;
	}

	/**
	 * Create and configure a AuthModule object to the list of subresources
	 * 
	 * @param key
	 *            The key for the AuthModule resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T authModule(String childKey) {
		authModule(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied AuthModule object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T authModule(AuthModuleSupplier supplier) {
		authModule(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for JaspiAuthentication
	 */
	public static class JaspiAuthenticationResources {
		/**
		 * List of "named" login modules that are used by jaspi authentication
		 * modules.
		 */
		private List<LoginModuleStack> loginModuleStacks = new java.util.ArrayList<>();
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<AuthModule> authModules = new java.util.ArrayList<>();

		/**
		 * Get the list of LoginModuleStack resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModuleStack> loginModuleStacks() {
			return this.loginModuleStacks;
		}

		/**
		 * Get the list of AuthModule resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<AuthModule> authModules() {
			return this.authModules;
		}
	}
}