package org.wildfly.swarm.config.security.security_domain.authorization;

import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PolicyModuleConsumer<T extends PolicyModule<T>> {

	/**
	 * Configure a pre-constructed instance of PolicyModule resource
	 * 
	 * @parameter Instance of PolicyModule to configure
	 * @return nothing
	 */
	void accept(T value);

	default PolicyModuleConsumer<T> andThen(PolicyModuleConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}