package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Custom filter
 */
@Address("/subsystem=undertow/configuration=filter/custom-filter=*")
@ResourceType("custom-filter")
public class CustomFilter<T extends CustomFilter<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String className;
	private String module;
	private Map parameters;

	public CustomFilter(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of HttpHandler
	 */
	@ModelNodeBinding(detypedName = "class-name")
	public String className() {
		return this.className;
	}

	/**
	 * Class name of HttpHandler
	 */
	@SuppressWarnings("unchecked")
	public T className(String value) {
		Object oldValue = this.className;
		this.className = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("className", oldValue, value);
		return (T) this;
	}

	/**
	 * Module name where class can be loaded from
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Module name where class can be loaded from
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * Filter parameters
	 */
	@ModelNodeBinding(detypedName = "parameters")
	public Map parameters() {
		return this.parameters;
	}

	/**
	 * Filter parameters
	 */
	@SuppressWarnings("unchecked")
	public T parameters(Map value) {
		Object oldValue = this.parameters;
		this.parameters = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("parameters", oldValue, value);
		return (T) this;
	}

	/**
	 * Filter parameters
	 */
	public T parameter(String key, Object value) {
		if (this.parameters == null) {
			this.parameters = new java.util.HashMap<>();
		}
		this.parameters.put(key, value);
		return (T) this;
	}
}