/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.messaging_activemq.JMSBridge;
import org.wildfly.swarm.config.messaging_activemq.JMSBridgeConsumer;
import org.wildfly.swarm.config.messaging_activemq.JMSBridgeSupplier;
import org.wildfly.swarm.config.messaging_activemq.Server;
import org.wildfly.swarm.config.messaging_activemq.ServerConsumer;
import org.wildfly.swarm.config.messaging_activemq.ServerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=messaging-activemq")
@ResourceType(value="subsystem")
@Implicit
public class MessagingActiveMQ<T extends MessagingActiveMQ<T>> {
    private String key = "messaging-activemq";
    private PropertyChangeSupport pcs;
    private MessagingActiveMQResources subresources = new MessagingActiveMQResources();

    public MessagingActiveMQ() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MessagingActiveMQResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers = value;
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConsumer consumer) {
        Server child = new Server(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.server(child);
        return (T)this;
    }

    public T server(String childKey) {
        this.server(childKey, null);
        return (T)this;
    }

    public T server(ServerSupplier supplier) {
        this.server(supplier.get());
        return (T)this;
    }

    public T jmsBridges(List<JMSBridge> value) {
        this.subresources.jmsBridges = value;
        return (T)this;
    }

    public T jmsBridge(JMSBridge value) {
        this.subresources.jmsBridges.add(value);
        return (T)this;
    }

    public T jmsBridge(String childKey, JMSBridgeConsumer consumer) {
        JMSBridge child = new JMSBridge(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jmsBridge(child);
        return (T)this;
    }

    public T jmsBridge(String childKey) {
        this.jmsBridge(childKey, null);
        return (T)this;
    }

    public T jmsBridge(JMSBridgeSupplier supplier) {
        this.jmsBridge(supplier.get());
        return (T)this;
    }

    public static class MessagingActiveMQResources {
        private List<Server> servers = new ArrayList<Server>();
        private List<JMSBridge> jmsBridges = new ArrayList<JMSBridge>();

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        public Server server(String key) {
            return this.servers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JMSBridge> jmsBridges() {
            return this.jmsBridges;
        }

        public JMSBridge jmsBridge(String key) {
            return this.jmsBridges.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

