/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.transactions.log_store;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.log_store.transactions.Participants;
import org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsConsumer;
import org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsSupplier;

@Address(value="/subsystem=transactions/log-store=log-store/transactions=*")
@ResourceType(value="transactions")
public class Transactions<T extends Transactions<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private Long ageInSeconds;
    private String id;
    private String jmxName;
    private String type;
    private TransactionsResources subresources = new TransactionsResources();

    public Transactions(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="age-in-seconds")
    public Long ageInSeconds() {
        return this.ageInSeconds;
    }

    public T ageInSeconds(Long value) {
        Long oldValue = this.ageInSeconds;
        this.ageInSeconds = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("ageInSeconds", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="id")
    public String id() {
        return this.id;
    }

    public T id(String value) {
        String oldValue = this.id;
        this.id = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("id", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jmx-name")
    public String jmxName() {
        return this.jmxName;
    }

    public T jmxName(String value) {
        String oldValue = this.jmxName;
        this.jmxName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jmxName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }

    public TransactionsResources subresources() {
        return this.subresources;
    }

    public T participants(List<Participants> value) {
        this.subresources.participants = value;
        return (T)this;
    }

    public T participants(Participants value) {
        this.subresources.participants.add(value);
        return (T)this;
    }

    public T participants(String childKey, ParticipantsConsumer consumer) {
        Participants child = new Participants(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.participants(child);
        return (T)this;
    }

    public T participants(String childKey) {
        this.participants(childKey, null);
        return (T)this;
    }

    public T participants(ParticipantsSupplier supplier) {
        this.participants(supplier.get());
        return (T)this;
    }

    public static class TransactionsResources {
        private List<Participants> participants = new ArrayList<Participants>();

        @Subresource
        public List<Participants> participants() {
            return this.participants;
        }

        public Participants participants(String key) {
            return this.participants.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

