package org.wildfly.swarm.config;

import org.wildfly.swarm.config.EJB3;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface EJB3Consumer<T extends EJB3<T>> {

	/**
	 * Configure a pre-constructed instance of EJB3 resource
	 * 
	 * @parameter Instance of EJB3 to configure
	 * @return nothing
	 */
	void accept(T value);

	default EJB3Consumer<T> andThen(EJB3Consumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}