package org.wildfly.swarm.config;

import org.wildfly.swarm.config.JSF;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface JSFConsumer<T extends JSF<T>> {

	/**
	 * Configure a pre-constructed instance of JSF resource
	 * 
	 * @parameter Instance of JSF to configure
	 * @return nothing
	 */
	void accept(T value);

	default JSFConsumer<T> andThen(JSFConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}