package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Mail;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface MailConsumer<T extends Mail<T>> {

	/**
	 * Configure a pre-constructed instance of Mail resource
	 * 
	 * @parameter Instance of Mail to configure
	 * @return nothing
	 */
	void accept(T value);

	default MailConsumer<T> andThen(MailConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}