package org.wildfly.swarm.config.ejb3.service;

import org.wildfly.swarm.config.ejb3.service.FileDataStore;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface FileDataStoreConsumer<T extends FileDataStore<T>> {

	/**
	 * Configure a pre-constructed instance of FileDataStore resource
	 * 
	 * @parameter Instance of FileDataStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default FileDataStoreConsumer<T> andThen(FileDataStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}