package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.ExpirationComponent;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ExpirationComponentConsumer<T extends ExpirationComponent<T>> {

	/**
	 * Configure a pre-constructed instance of ExpirationComponent resource
	 * 
	 * @parameter Instance of ExpirationComponent to configure
	 * @return nothing
	 */
	void accept(T value);

	default ExpirationComponentConsumer<T> andThen(
			ExpirationComponentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}