package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.NoneStore;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface NoneStoreConsumer<T extends NoneStore<T>> {

	/**
	 * Configure a pre-constructed instance of NoneStore resource
	 * 
	 * @parameter Instance of NoneStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default NoneStoreConsumer<T> andThen(NoneStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}