package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.CustomFormatter;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface CustomFormatterConsumer<T extends CustomFormatter<T>> {

	/**
	 * Configure a pre-constructed instance of CustomFormatter resource
	 * 
	 * @parameter Instance of CustomFormatter to configure
	 * @return nothing
	 */
	void accept(T value);

	default CustomFormatterConsumer<T> andThen(CustomFormatterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}