package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PeriodicRotatingFileHandlerConsumer<T extends PeriodicRotatingFileHandler<T>> {

	/**
	 * Configure a pre-constructed instance of PeriodicRotatingFileHandler
	 * resource
	 * 
	 * @parameter Instance of PeriodicRotatingFileHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default PeriodicRotatingFileHandlerConsumer<T> andThen(
			PeriodicRotatingFileHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}