package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.ManagementOperationsService;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ManagementOperationsServiceConsumer<T extends ManagementOperationsService<T>> {

	/**
	 * Configure a pre-constructed instance of ManagementOperationsService
	 * resource
	 * 
	 * @parameter Instance of ManagementOperationsService to configure
	 * @return nothing
	 */
	void accept(T value);

	default ManagementOperationsServiceConsumer<T> andThen(
			ManagementOperationsServiceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}